package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@ApiModel(value = "ProductFile", description = "商品文件")
@Entity
@Table(name="`product_file`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_file`", comment = "商品文件")
public class ProductFile extends TenantEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -7224990740188563409L;

  /** 商品编号 */
  @JoinColumn(name = "product_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编号 '")
  @SaturnColumn(description = "商品编号")
  @ApiModelProperty("商品编号")
  @ManyToOne(fetch = FetchType.LAZY)
  private Product product;

  /** 相对路径 */
  @Column(name = "relative_path", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
  @SaturnColumn(description = "文件名")
  @ApiModelProperty("文件名")
  private String fileName;

  /** 图片类型 */
  @Column(name = "type", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片类型 '")
  @SaturnColumn(description = "图片类型")
  @ApiModelProperty("图片类型")
  private String type;

  /** 是主图 */
  @Column(name = "is_main_image", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 是主图 '")
  @SaturnColumn(description = "是主图")
  @ApiModelProperty("是主图")
  @JsonProperty(value = "isMainImage")
  private Boolean isMainImage;


  /**
   * 排序（按数字顺序排列）
   */
  @Column(name = "sort_index", nullable = false,columnDefinition = "INT(7) COMMENT '排序（按数字顺序排列）'")
  @SaturnColumn(description = "排序（按数字顺序排列）")
  @ApiModelProperty("排序（按数字顺序排列）")
  private Integer sortIndex;

  /**
   * 图片资源库 资源
   * 保留原有图片查看方式，保证升级过后正常使用
   * 当前表中图片数据，为资源库中数据的镜像
   */
  @JoinColumn(name = "resource_id" , nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片ID '")
  @SaturnColumn(description = "图片ID")
  @ApiModelProperty("图片ID")
  @ManyToOne(fetch = FetchType.LAZY)
  @NotFound(action = NotFoundAction.IGNORE)
  private ProductImageResource productImageResource;

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public Boolean getMainImage() {
    return isMainImage;
  }

  public void setMainImage(Boolean mainImage) {
    isMainImage = mainImage;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public String getRelativePath(){
    return this.relativePath;
  }

  public void setRelativePath(String relativePath){
    this.relativePath = relativePath;
  }

  public String getFileName(){
    return this.fileName;
  }

  public void setFileName(String fileName){
    this.fileName = fileName;
  }

  public String getType(){
    return this.type;
  }

  public void setType(String type){
    this.type = type;
  }

  public ProductImageResource getProductImageResource() {
    return productImageResource;
  }

  public void setProductImageResource(ProductImageResource productImageResource) {
    this.productImageResource = productImageResource;
  }
}