package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@ApiModel(value = "ProductImageResource", description = "商品图片资源库")
@Entity
@Table(name="`product_image_resource`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_image_resource`", comment = "商品图片资源库")
public class ProductImageResource extends TenantOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = 1549121622478198571L;
  /** 商品编号 */
  @JoinColumn(name = "product_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编号 '")
  @SaturnColumn(description = "商品编号")
  @ApiModelProperty("商品编号")
  @ManyToOne(fetch = FetchType.LAZY)
  private Product product;

  /** 相对路径 */
  @Column(name = "relative_path", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名 '")
  @SaturnColumn(description = "文件名")
  @ApiModelProperty("文件名")
  private String fileName;

  /** 图片类型 */
  @Column(name = "type", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片类型 '")
  @SaturnColumn(description = "图片类型")
  @ApiModelProperty("图片类型")
  private String type;

  /**
   * 是否使用图片
   */
  @Column(name = "use_image", nullable = false, columnDefinition = "bit(1) COMMENT ' 是否使用图片：false否，true是 '")
  @SaturnColumn(description = "是否使用图片")
  @ApiModelProperty(name = "required", value = "是否使用图片：false否，true是", required = true)
  private Boolean useImage;

  /**
   * 源文件名称
   */
  @ApiModelProperty("源文件名称")
  @Transient
  private String originalFileName;


  /**
   * 文件大小
   */
  @ApiModelProperty("文件大小")
  @Transient
  private Long fileSize;

  public Long getFileSize() {
    return fileSize;
  }

  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Boolean getUseImage() {
    return useImage;
  }

  public void setUseImage(Boolean useImage) {
    this.useImage = useImage;
  }

  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }
}