package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@ApiModel(value = "ProductMultipleSpecification", description = "商品多规格")
@Entity
@Table(name="`product_multiple_specification`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_multiple_specification`", comment = "商品多规格")
public class ProductMultipleSpecification extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -3448923084237929053L;

  /** 商品编码 */
  @JoinColumn(name = "product_id" ,nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编码 '")
  @SaturnColumn(description = "商品编码")
  @ApiModelProperty("商品编码")
  @ManyToOne(fetch = FetchType.LAZY)
  private Product product;

  /** 规格键 */
  @Column(name = "spec_key", nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格键 '")
  @SaturnColumn(description = "规格键")
  @ApiModelProperty("规格键")
  private String specKey;

  /** 规格值 */
  @Column(name = "spec_value", nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格值 '")
  @SaturnColumn(description = "规格值")
  @ApiModelProperty("规格值")
  private String specValue;

  public String getSpecKey(){
    return this.specKey;
  }

  public void setSpecKey(String specKey){
    this.specKey = specKey;
  }

  public String getSpecValue(){
    return this.specValue;
  }

  public void setSpecValue(String specValue){
    this.specValue = specValue;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }
}