package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

@ApiModel(value = "ProductPriceModifyLog", description = "商品价格变更日志")
@Entity
@Table(name = "`product_price_modify_log`" , indexes = @Index(columnList = "tenant_code , product_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_price_modify_log`", comment = "商品价格变更日志")
@BuildCustomRepository
public class ProductPriceModifyLog extends TenantOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -5241925733946311598L;

  /**
   * 商品编码
   */
  @Column(name = "product_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  @SaturnColumn(description = "商品编码")
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @Column(name = "product_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品名称 '")
  @SaturnColumn(description = "商品名称")
  @ApiModelProperty("商品名称")
  private String productName;


  /**
   * 规格编号
   */
  @Column(name = "product_specification_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 规格编号 '")
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @Column(name = "product_specification_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格名称 '")
  @SaturnColumn(description = "规格名称")
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 单位编号 */
  @Column(name = "unit_code", nullable = false,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @Column(name = "unit_name", nullable = false,length = 128,columnDefinition = "VARCHAR(128) COMMENT ' 单位名称 '")
  @SaturnColumn(description = "单位名称")
  @ApiModelProperty("单位名称")
  private String unitName;

  /** 客户编码 */
  @Column(name = "customer_code", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  @SaturnColumn(description = "客户编码")
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户名称 '")
  @SaturnColumn(description = "客户名称")
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 价格类型 1.销售价 2.进货价
   */
  @Column(name = "price_type", nullable = false, columnDefinition = "int(11) COMMENT ' 价格类型 1.销售价 2.进货价 '")
  @SaturnColumn(description = "价格类型 1.销售价 2.进货价")
  @ApiModelProperty("销售价格类型 1.销售价 2.进货价")
  private Integer priceType;

  /**
   * 调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调
   */
  @Column(name = "adjust_type", nullable = false, columnDefinition = "int(11) COMMENT ' 调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调 '")
  @SaturnColumn(description = "调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调")
  @ApiModelProperty("调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调")
  private Integer adjustType;

  /**
   * 调整金额
   */
  @Column(name = "adjust_money", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 调整金额 '")
  @SaturnColumn(description = "调整金额")
  @ApiModelProperty("调整金额")
  private BigDecimal adjustMoney;


  /**
   * 调整前价格
   */
  @Column(name = "old_money", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 调整前价格 '")
  @SaturnColumn(description = "调整前价格")
  @ApiModelProperty("调整前价格")
  private BigDecimal oldMoney;

  /**
   * 调整后金额
   */
  @Column(name = "after_money", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 调整后金额 '")
  @SaturnColumn(description = "调整后金额")
  @ApiModelProperty("调整后金额")
  private BigDecimal afterMoney;

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public Integer getPriceType() {
    return priceType;
  }

  public void setPriceType(Integer priceType) {
    this.priceType = priceType;
  }

  public Integer getAdjustType() {
    return adjustType;
  }

  public void setAdjustType(Integer adjustType) {
    this.adjustType = adjustType;
  }

  public BigDecimal getAdjustMoney() {
    return adjustMoney;
  }

  public void setAdjustMoney(BigDecimal adjustMoney) {
    this.adjustMoney = adjustMoney;
  }

  public BigDecimal getOldMoney() {
    return oldMoney;
  }

  public void setOldMoney(BigDecimal oldMoney) {
    this.oldMoney = oldMoney;
  }

  public BigDecimal getAfterMoney() {
    return afterMoney;
  }

  public void setAfterMoney(BigDecimal afterMoney) {
    this.afterMoney = afterMoney;
  }
}
