package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

@ApiModel(value = "ProductPricing", description = "产品定价")
@Entity
@Table(name="`product_pricing`" , indexes = {@Index(columnList = "tenant_code , product_id")})
@org.hibernate.annotations.Table(appliesTo = "`product_pricing`", comment = "产品定价")
public class ProductPricing extends TenantOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -6016603322582237005L;

  /** 商品编号 */
  @SaturnColumn(description = "商品编号")
  @ApiModelProperty("商品编号")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "product_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编号 '")
  private Product product;

  /** 规格编号 */
  @JoinColumn(name = "specification_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 规格编号 '")
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  @ManyToOne(fetch = FetchType.LAZY)
  @NotFound(action= NotFoundAction.IGNORE)
  private ProductSpecification productSpecification;

  /** 客户级别 */
  @Column(name = "customer_level", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 客户级别 '")
  @SaturnColumn(description = "客户级别")
  @ApiModelProperty("客户级别")
  private String customerLevel;

  /** 级别名称 */
  @Column(name = "level_name", nullable = false,  length=128 , columnDefinition = "VARCHAR(128) COMMENT ' 级别名称 '")
  @SaturnColumn(description = "级别名称")
  @ApiModelProperty("级别名称")
  private String levelName;

  /** 客户编码 */
  @Column(name = "customer_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  @SaturnColumn(description = "客户编码")
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 客户名称
   */
  @Column(name = "customer_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户名称 '")
  @SaturnColumn(description = "客户名称")
  @ApiModelProperty("客户名称")
  private String customerName;

  /** 是客户编码 */
  @Column(name = "is_customer_code", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 是客户编码 '")
  @SaturnColumn(description = "是客户编码")
  @ApiModelProperty("是客户编码")
  private Boolean isCustomerCode;

  /**
   * 产品定价按单位定价
   */
  @SaturnColumn(description = "产品定价按单位定价")
  @ApiModelProperty("产品定价按单位定价")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "productPricing")
  private Set<ProductPricingUnitSpecification> productPricingUnitSpecifications;


  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public void setCustomerCode(Boolean customerCode) {
    isCustomerCode = customerCode;
  }

  public String getCustomerLevel(){
    return this.customerLevel;
  }

  public void setCustomerLevel(String customerLevel){
    this.customerLevel = customerLevel;
  }

  public String getCustomerCode(){
    return this.customerCode;
  }

  public void setCustomerCode(String customerCode){
    this.customerCode = customerCode;
  }

  public Boolean getIsCustomerCode(){
    return this.isCustomerCode;
  }

  public void setIsCustomerCode(Boolean isCustomerCode){
    this.isCustomerCode = isCustomerCode;
  }

  public String getLevelName() {
    return levelName;
  }

  public void setLevelName(String levelName) {
    this.levelName = levelName;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public Set<ProductPricingUnitSpecification> getProductPricingUnitSpecifications() {
    return productPricingUnitSpecifications;
  }

  public void setProductPricingUnitSpecifications(Set<ProductPricingUnitSpecification> productPricingUnitSpecifications) {
    this.productPricingUnitSpecifications = productPricingUnitSpecifications;
  }

  public ProductSpecification getProductSpecification() {
    return productSpecification;
  }

  public void setProductSpecification(ProductSpecification productSpecification) {
    this.productSpecification = productSpecification;
  }
}