package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;

@ApiModel(value = "ProductPricingUnitSpecification", description = "产品定价按单位和规格定价")
@Entity
@Table(name="`product_pricing_unit_specification`" )
@org.hibernate.annotations.Table(appliesTo = "`product_pricing_unit_specification`", comment = "产品定价按单位和规格定价")
public class ProductPricingUnitSpecification extends TenantEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 8526866497963237980L;

  /** 产品定价 */
  @SaturnColumn(description = "产品定价")
  @ApiModelProperty("产品定价")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "product_pricing_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 产品定价 '")
  private ProductPricing productPricing;

  /** 订货价格 */
  @Column(name = "order_price", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 订货价格 '")
  @SaturnColumn(description = "订货价格")
  @ApiModelProperty("订货价格")
  private BigDecimal orderPrice;

  /** 单位编号 */
  @Column(name = "unit_code", nullable = false,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @Column(name = "unit_name", nullable = false,length = 128,columnDefinition = "VARCHAR(128) COMMENT ' 单位名称 '")
  @SaturnColumn(description = "单位名称")
  @ApiModelProperty("单位名称")
  private String unitName;

  /**
   * 规格编号
   */
  @Column(name = "product_specification_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 规格编号 '")
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @Column(name = "product_specification_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格名称 '")
  @SaturnColumn(description = "规格名称")
  @ApiModelProperty("规格名称")
  private String productSpecificationName;


  public ProductPricing getProductPricing() {
    return productPricing;
  }

  public void setProductPricing(ProductPricing productPricing) {
    this.productPricing = productPricing;
  }

  public BigDecimal getOrderPrice() {
    return orderPrice;
  }

  public void setOrderPrice(BigDecimal orderPrice) {
    this.orderPrice = orderPrice;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }
}
