package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

@ApiModel(value = "ProductShowCategory", description = "商品前端展示分类")
@Entity
@Table(name = "`product_show_category`" , indexes = {@Index(columnList = "tenant_code , code" ,unique = true) ,
                                                @Index(columnList = "tenant_code , parent_code") , 
                                                @Index(columnList = "create_time")})
@org.hibernate.annotations.Table(appliesTo = "`product_show_category`", comment = "商品前端展示分类")
public class ProductShowCategory extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -1007837678128225371L;

  /**
   * 分类名称
   */
  @Column(name = "name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 分类名称 '")
  @SaturnColumn(description = "分类名称")
  @ApiModelProperty("分类名称")
  private String name;

  /**
   * 分类编码
   */
  @Column(name = "code", nullable = false,  length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分类编码 '")
  @SaturnColumn(description = "分类编码")
  @ApiModelProperty("分类编码")
  private String code;

  /**
   * 层级
   */
  @Column(name = "level", nullable = true, columnDefinition = "INT COMMENT ' 层级 '")
  @SaturnColumn(description = "层级")
  @ApiModelProperty("层级")
  private Integer level;

  /**
   * 父级编号
   */
  @Column(name = "parent_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 父级编号 '")
  @SaturnColumn(description = "父级编号")
  @ApiModelProperty("父级编号")
  private String parentCode;

  /**
   * 快速编号
   */
  @Column(name = "flat_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 快速编号 '")
  @SaturnColumn(description = "快速编号")
  @ApiModelProperty("快速编号")
  private String flatCode;

  /**
   * 商品信息
   */
  @SaturnColumn(description = "商品信息")
  @ApiModelProperty("商品信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "productShowCategory")
  private Set<Product> products;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getFlatCode() {
    return flatCode;
  }

  public void setFlatCode(String flatCode) {
    this.flatCode = flatCode;
  }

  public Set<Product> getProducts() {
    return products;
  }

  public void setProducts(Set<Product> products) {
    this.products = products;
  }
}