package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

@ApiModel(value = "ProductSpecification", description = "商品规格")
@Entity
@Table(name = "`product_specification`" , indexes = {@Index(columnList = "tenant_code , product_specification_code") , 
                                                     @Index(columnList = "tenant_code , product_id") , 
                                                     @Index(columnList = "create_time")})
@org.hibernate.annotations.Table(appliesTo = "`product_specification`", comment = "商品规格")
public class ProductSpecification extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -4219958747254808255L;

  /**
   * 商品编号
   */
  @JoinColumn(name = "product_id" ,nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编号 '")
  @SaturnColumn(description = "商品编号")
  @ApiModelProperty("商品编号")
  @ManyToOne(fetch = FetchType.LAZY)
  private Product product;

  /**
   * 规格编号
   */
  @Column(name = "product_specification_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 规格编号 '")
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @Column(name = "product_specification_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 规格名称 '")
  @SaturnColumn(description = "规格名称")
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /**
   * 起订量
   */
  @Column(name = "minimum_order_quantity", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 起订量 '")
  @SaturnColumn(description = "起订量")
  @ApiModelProperty("起订量")
  private BigDecimal minimumOrderQuantity;

  /**
   * 限定量
   */
  @Column(name = "maximum_order_quantity", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 限定量 '")
  @SaturnColumn(description = "限定量")
  @ApiModelProperty("限定量")
  private BigDecimal maximumOrderQuantity;

  /**
   * 主图路径
   */
  @Column(name = "main_image_path", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 主图路径 '")
  @SaturnColumn(description = "主图路径")
  @ApiModelProperty("主图路径")
  private String mainImagePath;

  /**
   * 主图名称
   */
  @Column(name = "main_image_name", length = 255, nullable = false, columnDefinition = "VARCHAR(128) COMMENT ' 主图名称 '")
  @SaturnColumn(description = "主图名称")
  @ApiModelProperty("主图名称")
  private String mainImageName;

  /**
   * 图片资源库 资源
   * 保留原有图片查看方式，保证升级过后正常使用
   * 当前表中图片数据，为资源库中数据的镜像
   */
  @JoinColumn(name = "resource_id" , nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 图片ID '")
  @SaturnColumn(description = "图片ID")
  @ApiModelProperty("图片ID")
  @ManyToOne(fetch = FetchType.LAZY)
  @NotFound(action = NotFoundAction.IGNORE)
  private ProductImageResource productImageResource;


  /** 条形码 */
  @SaturnColumn(description = "条形码")
  @ApiModelProperty("条形码")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "productSpecification")
  private Set<ProductBarCodeInfo> productBarCodeInfos;

  @SaturnColumn(description = "规格与价格")
  @ApiModelProperty("规格与价格")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "productSpecification")
  @NotFound(action = NotFoundAction.IGNORE)
  private Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices;


  /**
   * 规格客户定价
   */
  @SaturnColumn(description = "规格客户定价信息")
  @ApiModelProperty("规格客户定价信息")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "productSpecification")
  private Set<ProductPricing> productPricings;

  public Set<ProductUnitSpecificationAndPrice> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }

  public Set<ProductPricing> getProductPricings() {
    return productPricings;
  }

  public void setProductPricings(Set<ProductPricing> productPricings) {
    this.productPricings = productPricings;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public BigDecimal getMinimumOrderQuantity() {
    return minimumOrderQuantity;
  }

  public void setMinimumOrderQuantity(BigDecimal minimumOrderQuantity) {
    this.minimumOrderQuantity = minimumOrderQuantity;
  }

  public BigDecimal getMaximumOrderQuantity() {
    return maximumOrderQuantity;
  }

  public void setMaximumOrderQuantity(BigDecimal maximumOrderQuantity) {
    this.maximumOrderQuantity = maximumOrderQuantity;
  }

  public String getMainImagePath() {
    return mainImagePath;
  }

  public void setMainImagePath(String mainImagePath) {
    this.mainImagePath = mainImagePath;
  }

  public String getMainImageName() {
    return mainImageName;
  }

  public void setMainImageName(String mainImageName) {
    this.mainImageName = mainImageName;
  }

  public Set<ProductBarCodeInfo> getProductBarCodeInfos() {
    return productBarCodeInfos;
  }

  public void setProductBarCodeInfos(Set<ProductBarCodeInfo> productBarCodeInfos) {
    this.productBarCodeInfos = productBarCodeInfos;
  }


  public ProductImageResource getProductImageResource() {
    return productImageResource;
  }

  public void setProductImageResource(ProductImageResource productImageResource) {
    this.productImageResource = productImageResource;
  }
}