package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import java.util.Set;

@ApiModel(value = "ProductTag", description = "商品标签")
@Entity
@Table(name = "`product_tag`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_tag`", comment = "商品标签")
public class ProductTag extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 5708560430884218756L;

  /**
   * 标签名
   */
  @Column(name = "tag_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 标签名 '")
  @SaturnColumn(description = "标签名")
  @ApiModelProperty("标签名")
  private String tagName;

  /**
   * 标签编号
   */
  @Column(name = "tag_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 标签编号 '")
  @SaturnColumn(description = "标签编号")
  @ApiModelProperty("标签编号")
  private String tagCode;

  /**
   * 层级
   */
  @Column(name = "level", nullable = true, columnDefinition = "INT COMMENT ' 层级 '")
  @SaturnColumn(description = "层级")
  @ApiModelProperty("层级")
  private Integer level;

  /**
   * 父级
   */
  @Column(name = "parent_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 父级 '")
  @SaturnColumn(description = "父级")
  @ApiModelProperty("父级")
  private String parentCode;

  /**
   * 快速编号
   */
  @Column(name = "flat_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 快速编号 '")
  @SaturnColumn(description = "快速编号")
  @ApiModelProperty("快速编号")
  private String flatCode;

  /** 状态 1正常, 0禁用(枚举). **/
  @ApiModelProperty(name="tstatus" , value="状态 1正常, 0禁用." , required=true)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '状态 1正常, 0禁用(枚举)'")
  @SaturnColumn(description="启用/禁用")
  private Integer tstatus = 1;

  /**
   * 商品信息
   */
  @SaturnColumn(description = "商品信息")
  @ApiModelProperty("商品信息")
  @ManyToMany(fetch = FetchType.LAZY, mappedBy = "tags")
  private Set<Product> products;

  public String getTagName() {
    return tagName;
  }

  public void setTagName(String tagName) {
    this.tagName = tagName;
  }

  public String getTagCode() {
    return tagCode;
  }

  public void setTagCode(String tagCode) {
    this.tagCode = tagCode;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getFlatCode() {
    return flatCode;
  }

  public void setFlatCode(String flatCode) {
    this.flatCode = flatCode;
  }

  public Set<Product> getProducts() {
    return products;
  }

  public void setProducts(Set<Product> products) {
    this.products = products;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
}