package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

@ApiModel(value = "ProductUnit", description = "商品单位")
@Entity
@Table(name="`product_unit`" , indexes = @Index(columnList = "unit_code , tenant_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "`product_unit`", comment = "商品单位")
public class ProductUnit extends TenantOpEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -5390825972582447303L;

  /** 单位编号 */
  @Column(name = "unit_code", nullable = false,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @Column(name = "unit_name", nullable = false,length = 128,columnDefinition = "VARCHAR(128) COMMENT ' 单位名称 '")
  @SaturnColumn(description = "单位名称")
  @ApiModelProperty("单位名称")
  private String unitName;

  /** 状态 1正常, 0禁用(枚举). **/
  @ApiModelProperty(name="tstatus" , value="状态 1正常, 0禁用." , required=true)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '状态 1正常, 0禁用(枚举)'")
  @SaturnColumn(description="启用/禁用")
  private Integer tstatus = 1;

  /** 商品单位和价格 */
  @ApiModelProperty("商品单位和价格")
  @SaturnColumn(description = "商品单位和价格")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "productUnit")
  private Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices;


  public String getUnitCode(){
    return this.unitCode;
  }

  public void setUnitCode(String unitCode){
    this.unitCode = unitCode;
  }

  public String getUnitName(){
    return this.unitName;
  }

  public void setUnitName(String unitName){
    this.unitName = unitName;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Set<ProductUnitSpecificationAndPrice> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }
}