package com.bizunited.empower.business.product.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;

@ApiModel(value = "ProductUnitSpecificationAndPrice", description = "单位规格与价格")
@Entity
@Table(name="`product_unit_specification_and_price`" , indexes = @Index(columnList = "tenant_code"))
@org.hibernate.annotations.Table(appliesTo = "`product_unit_specification_and_price`", comment = "单位规格与价格")
public class ProductUnitSpecificationAndPrice extends TenantEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -4382379793700750487L;

  /** 商品编号 */
  @JoinColumn(name = "product_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品编号 '")
  @SaturnColumn(description = "商品编号")
  @ApiModelProperty("商品编号")
  @ManyToOne(fetch = FetchType.LAZY)
  private Product product;

  /** 单位编号 */
  @JoinColumn(name = "unit_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 单位编号 '")
  @SaturnColumn(description = "单位编号")
  @ApiModelProperty("单位编号")
  @ManyToOne(fetch = FetchType.LAZY)
  private ProductUnit productUnit;

  /** 规格编号 */
  @JoinColumn(name = "specification_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 规格编号 '")
  @SaturnColumn(description = "规格编号")
  @ApiModelProperty("规格编号")
  @ManyToOne(fetch = FetchType.LAZY)
  private ProductSpecification productSpecification;


  /** 是基本单位 */
  @Column(name = "is_basic_unit", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 是基本单位 '")
  @SaturnColumn(description = "是基本单位")
  @ApiModelProperty("是基本单位")
  private Boolean isBasicUnit;

  /** 允许购买 */
  @Column(name = "allow_purchase", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 允许购买 '")
  @SaturnColumn(description = "允许购买")
  @ApiModelProperty("允许购买")
  private Boolean allowPurchase;

  /** 默认购买 */
  @Column(name = "default_purchase", nullable = false, columnDefinition = "tinyint(1) COMMENT ' 默认购买 '")
  @SaturnColumn(description = "默认购买")
  @ApiModelProperty("默认购买")
  private Boolean defaultPurchase;

  /** 换算比例 */
  @Column(name = "conversion_ratio", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 换算比例 '")
  @SaturnColumn(description = "换算比例")
  @ApiModelProperty("换算比例")
  private BigDecimal conversionRatio;

  /** 参考进货价 */
  @Column(name = "reference_purchase_price", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 参考进货价 '")
  @SaturnColumn(description = "参考进货价")
  @ApiModelProperty("参考进货价")
  private BigDecimal referencePurchasePrice;

  /** 销售价 */
  @Column(name = "selling_price", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT ' 销售价 '")
  @SaturnColumn(description = "销售价")
  @ApiModelProperty("销售价")
  private BigDecimal sellingPrice;

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public ProductUnit getProductUnit() {
    return productUnit;
  }

  public void setProductUnit(ProductUnit productUnit) {
    this.productUnit = productUnit;
  }

  public Boolean getBasicUnit() {
    return isBasicUnit;
  }

  public void setBasicUnit(Boolean basicUnit) {
    isBasicUnit = basicUnit;
  }

  public Boolean getAllowPurchase() {
    return allowPurchase;
  }

  public void setAllowPurchase(Boolean allowPurchase) {
    this.allowPurchase = allowPurchase;
  }

  public Boolean getDefaultPurchase() {
    return defaultPurchase;
  }

  public void setDefaultPurchase(Boolean defaultPurchase) {
    this.defaultPurchase = defaultPurchase;
  }

  public BigDecimal getConversionRatio() {
    return conversionRatio;
  }

  public void setConversionRatio(BigDecimal conversionRatio) {
    this.conversionRatio = conversionRatio;
  }

  public BigDecimal getReferencePurchasePrice() {
    return referencePurchasePrice;
  }

  public void setReferencePurchasePrice(BigDecimal referencePurchasePrice) {
    this.referencePurchasePrice = referencePurchasePrice;
  }

  public BigDecimal getSellingPrice() {
    return sellingPrice;
  }

  public void setSellingPrice(BigDecimal sellingPrice) {
    this.sellingPrice = sellingPrice;
  }

  public ProductSpecification getProductSpecification() {
    return productSpecification;
  }

  public void setProductSpecification(ProductSpecification productSpecification) {
    this.productSpecification = productSpecification;
  }
}