package com.bizunited.empower.business.product.feign;

import com.bizunited.empower.business.product.feign.fallback.ProductFeignClientFallback;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 商品库远程调用
 *
 * @author lihuan
 */
@FeignClient(name = "saas-product", url = "${saas.baseUrl}", path = "/v1/product", fallback = ProductFeignClientFallback.class)
public interface ProductFeignClient {

  /**
   * 通过条形码查询商品信息
   *
   * @param appId
   * @param sign
   * @param barCode
   * @return
   */
  @GetMapping("findByBarCode")
  ResponseModel findByBarCode(@RequestParam("appId") String appId, @RequestParam("sign") String sign, @RequestParam("barCode") String barCode);
}
