package com.bizunited.empower.business.product.optimize.init;

import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.service.notifier.CacheRedisMessageForProductListener;
import org.apache.commons.lang3.tuple.Pair;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * ProductCacheRedisMessageStartupRunner
 * 在应用程序启动完成后，订阅redis的监听，以便资源桶中任何进程的商品信息缓存发生变化后
 * 本进程能知晓这个变化，并进行相关处理
 *
 * @Author: hefan
 * @Date: 2021/6/15 18:16
 */
@Component
public class ProductCacheRedisMessageStartupRunner implements ApplicationListener<ApplicationReadyEvent> {

  @Autowired
  private Redisson redisson;
  @Autowired
  private CacheRedisMessageForProductListener cacheRedisMessageForProductListener;

  @Override
  public void onApplicationEvent(ApplicationReadyEvent event) {
    RTopic topicForProduct = this.redisson.getTopic(ProductFlatService.PRODUCT_BASIC_INFO_NOTIFY);
    topicForProduct.addListener(Pair.class, this.cacheRedisMessageForProductListener);
  }

}
