package com.bizunited.empower.business.product.optimize.service;

import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Optional;

/**
 * ProductFlatService
 *
 * @Author: hefan
 * @Date: 2021/6/22 11:29
 */
public interface ProductFlatService {

  /**
   * 缓存变化订阅的固定键值
   */
  String PRODUCT_BASIC_INFO_NOTIFY = "_PRODUCT_BASIC_INFO_NOTIFY";

  /**
   * 当商品基础信息的任何写操作发生时，需要调用该方法，通过redis全局广播的方式，通知当前资源桶下的所有工作节点
   * 指定经销商下的某商品发生了变化，以便所有工作节点能够清理缓存
   * @param tenantCode
   */
  void notifyCacheRefresh(String tenantCode, String productCode);

  /**
   * 该方法用于直接清空指定经销商的缓存商品信息
   * @param pair left：经销商code，right：商品code
   */
  void clearCache(Pair<String, String> pair);

  /**
   * 按照指定的商品code集合，从缓存查询当前经销商下的商品信息（包括各种关联信息和冗余信息）
   * @param codeList
   * @return
   */
  List<ProductFlatVo> findByProductCodeList(List<String> codeList, String tenantCode);

  /**
   * 按照指定的商品code，从缓存查询当前经销商下的商品信息（包括各种关联信息和冗余信息）
   * @param productCode
   * @return
   */
  ProductFlatVo findByProductCode(String productCode);

  /**
   * 按照指定的商品规格code，从缓存查询当前经销商下的商品信息（包括各种关联信息和冗余信息）
   * @param specificationCode
   * @return
   */
  Optional<ProductFlatVo> findBySpecificationCode(String specificationCode);

  /**
   * 按照指定的商品规格code集合，从缓存查询当前经销商下的商品信息（包括各种关联信息和冗余信息）
   * @param specificationCodeList
   * @return
   */
  List<ProductFlatVo> findBySpecificationCodeList(List<String> specificationCodeList);
}
