package com.bizunited.empower.business.product.optimize.service.internal;

import com.bizunited.empower.business.product.optimize.vo.ProductFlatVo;
import com.bizunited.empower.business.product.optimize.service.ProductFlatForkJoinService;
import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import com.bizunited.empower.business.product.optimize.service.task.ProductFlatRecursiveTask;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import java.util.List;
import java.util.concurrent.ForkJoinPool;

/**
 * ProductFlatForkJoinServiceImpl  分治策略的service实现类
 *
 * @Author: hefan
 * @Date: 2021/6/22 11:30
 */
@Service("ProductFlatForkJoinServiceImpl")
public class ProductFlatForkJoinServiceImpl implements ProductFlatForkJoinService {

  @Autowired
  ProductFlatService productFlatService;

  /**
   * 单个task处理的商品查询数量，不得超过上限
   */
  @Value("${product.upperLimit:50}")
  private int upperLimit;

  /**
   * 先在需要使用的类通过注解的方式或其他方式注入获取JPA实体管理器工厂，再传入线程（task）对象
   */
  @PersistenceUnit
  private EntityManagerFactory emFactory;

  @Override
  public List<ProductFlatVo> findByProductCodeList(List<String> codeList) {
    if (CollectionUtils.isEmpty(codeList)) {
      return null;
    }
    ForkJoinPool pool = new ForkJoinPool();
    // 构造时，传入了JPA实体管理器工厂（以及 子线程需要的属性值）
    ProductFlatRecursiveTask taskLeft = new ProductFlatRecursiveTask(codeList,this.upperLimit, this.productFlatService, TenantUtils.getTenantCode(), TenantUtils.getAppCode(), emFactory);
    pool.invoke(taskLeft);
    List<ProductFlatVo> result = taskLeft.join();
    pool.shutdown();
    return result;
  }
}
