package com.bizunited.empower.business.product.optimize.service.notifier;

import com.bizunited.empower.business.product.optimize.service.ProductFlatService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * CacheRedisMessageForProductListener
 * 当商品模块收到redis订阅消息，说明当前桶下的某个进程中，已经发生了商品信息的变化
 * 这时需要接受redis的监听消息，以便进行缓存刷新
 *
 * @Author: hefan
 * @Date: 2021/6/15 18:20
 */
@Component
public class CacheRedisMessageForProductListener implements MessageListener<Pair<String,String>> {

  @Autowired
  ProductFlatService productFlatService;

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForProductListener.class);

  @Override
  public void onMessage(CharSequence channel, Pair<String,String> pair) {
    LOGGER.info("product basic info notifing ......");
    if(!StringUtils.isBlank(pair.getLeft())) {
      this.productFlatService.clearCache(pair);
    }
  }

}
