package com.bizunited.empower.business.product.optimize.vo;

import com.bizunited.empower.business.product.entity.ProductFile;
import com.bizunited.empower.business.product.entity.ProductMultipleSpecification;
import com.bizunited.empower.business.product.entity.ProductPricing;
import com.bizunited.empower.business.product.entity.ProductTag;
import com.bizunited.empower.business.product.entity.ProductUnitAndPrice;
import com.bizunited.empower.business.product.entity.ProductUnitSpecificationAndPrice;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * ProductFlatVo 优化商品模块使用 - 扁平化商品信息
 *
 * @Author: hefan
 * @Date: 2021/6/11 15:31
 */
public class ProductFlatVo implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -8938124793019569033L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 分类名称
   */
  @ApiModelProperty("分类名称")
  private String categoryName;

  /**
   * 分类编码
   */
  @ApiModelProperty("分类编码")
  private String categoryCode;

  /**
   * 父级编号
   */
  @ApiModelProperty("父级编号")
  private String categoryParentCode;

  /**
   * 快速编号
   */
  @ApiModelProperty("快速编号")
  private String categoryFlatCode;

  /**
   * 品牌名称
   */
  @ApiModelProperty("品牌名称")
  private String brandName;

  /**
   * 品牌编码
   */
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /**
   * logo相对路径
   */
  @ApiModelProperty("logo相对路径")
  private String brandLogoRelativePath;

  /**
   * logo文件名
   */
  @ApiModelProperty("logo文件名")
  private String brandLogoFileName;

  /**
   * 上架状态
   */
  @ApiModelProperty("上架状态：1，立即上架；2，暂不上架")
  private Integer shelfStatus;

  /**
   * 默认仓库
   */
  @ApiModelProperty("默认仓库")
  private String defaultWarehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 搜索关键字
   */
  @ApiModelProperty("搜索关键字")
  private String searchKeyword;

  /**
   * 备注信息
   */
  @ApiModelProperty("备注信息")
  private String remark;

  /**
   * 商品文件
   */
  @ApiModelProperty("商品文件")
  private Set<ProductFile> productFiles;

  /**
   * 商品多规格参数
   */
  @ApiModelProperty("商品多规格参数")
  private Set<ProductMultipleSpecification> productMultipleSpecifications;

  /**
   * 商品规格
   */
  @ApiModelProperty("商品规格")
  private Set<ProductSpecificationFlatVo> productSpecifications;
  /**
   *  商品规格 key：规格code
   */
  @ApiModelProperty("商品规格")
  private Map<String, ProductSpecificationFlatVo> productSpecificationMap;

  /**
   * 商品标签
   */
  @ApiModelProperty("商品标签")
  private Set<ProductTag> tags;
  /**
   * key:标签code
   */
  @ApiModelProperty("商品标签")
  private Map<String, ProductTag> tagMap;

  /**
   * 单位规格与价格
   */
  @ApiModelProperty("单位与价格")
  private Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices;


  /**
   * 单位价格
   */
  @ApiModelProperty("单位价格")
  private Set<ProductUnitAndPrice> productUnitAndPrices;

  /**
   * 单位价格
   *  key：单位code
   */
  private Map<String, ProductUnitAndPriceFlatVo> productUnitAndPriceMap;


  /**
   * 单位规格价格
   * key : 规格code+单位code
   */
  @ApiModelProperty("单位规格价格")
  private Map<String, ProductUnitSpecificationAndPriceFlatVo> productUnitSpecificationAndPriceFlatDtoMap;

  /**
   * 商品定价
   */
  @ApiModelProperty("商品定价")
  private Set<ProductPricing> productPricings;

  /**
   * 商品定价 key: 客户编码
   */
  @ApiModelProperty
  private Map<String, ProductPricingFlatVo> productPricingMap;


  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getCategoryName() {
    return categoryName;
  }

  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }

  public String getCategoryCode() {
    return categoryCode;
  }

  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }

  public String getCategoryParentCode() {
    return categoryParentCode;
  }

  public void setCategoryParentCode(String categoryParentCode) {
    this.categoryParentCode = categoryParentCode;
  }

  public String getCategoryFlatCode() {
    return categoryFlatCode;
  }

  public void setCategoryFlatCode(String categoryFlatCode) {
    this.categoryFlatCode = categoryFlatCode;
  }

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public String getBrandLogoRelativePath() {
    return brandLogoRelativePath;
  }

  public void setBrandLogoRelativePath(String brandLogoRelativePath) {
    this.brandLogoRelativePath = brandLogoRelativePath;
  }

  public String getBrandLogoFileName() {
    return brandLogoFileName;
  }

  public void setBrandLogoFileName(String brandLogoFileName) {
    this.brandLogoFileName = brandLogoFileName;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public String getDefaultWarehouseCode() {
    return defaultWarehouseCode;
  }

  public void setDefaultWarehouseCode(String defaultWarehouseCode) {
    this.defaultWarehouseCode = defaultWarehouseCode;
  }

  public String getWarehouseName() {
    return warehouseName;
  }

  public void setWarehouseName(String warehouseName) {
    this.warehouseName = warehouseName;
  }

  public String getSearchKeyword() {
    return searchKeyword;
  }

  public void setSearchKeyword(String searchKeyword) {
    this.searchKeyword = searchKeyword;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<ProductFile> getProductFiles() {
    return productFiles;
  }

  public void setProductFiles(Set<ProductFile> productFiles) {
    this.productFiles = productFiles;
  }

  public Set<ProductMultipleSpecification> getProductMultipleSpecifications() {
    return productMultipleSpecifications;
  }

  public void setProductMultipleSpecifications(Set<ProductMultipleSpecification> productMultipleSpecifications) {
    this.productMultipleSpecifications = productMultipleSpecifications;
  }

  public Set<ProductSpecificationFlatVo> getProductSpecifications() {
    return productSpecifications;
  }

  public void setProductSpecifications(Set<ProductSpecificationFlatVo> productSpecifications) {
    this.productSpecifications = productSpecifications;
  }

  public Set<ProductTag> getTags() {
    return tags;
  }

  public void setTags(Set<ProductTag> tags) {
    this.tags = tags;
  }

  public Set<ProductUnitSpecificationAndPrice> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }

  public Set<ProductPricing> getProductPricings() {
    return productPricings;
  }

  public void setProductPricings(Set<ProductPricing> productPricings) {
    this.productPricings = productPricings;
  }

  public Map<String, ProductSpecificationFlatVo> getProductSpecificationMap() {
    return productSpecificationMap;
  }

  public void setProductSpecificationMap(Map<String, ProductSpecificationFlatVo> productSpecificationMap) {
    this.productSpecificationMap = productSpecificationMap;
  }

  public Map<String, ProductTag> getTagMap() {
    return tagMap;
  }

  public void setTagMap(Map<String, ProductTag> tagMap) {
    this.tagMap = tagMap;
  }

  public Map<String, ProductUnitAndPriceFlatVo> getProductUnitAndPriceMap() {
    return productUnitAndPriceMap;
  }

  public void setProductUnitAndPriceMap(Map<String, ProductUnitAndPriceFlatVo> productUnitAndPriceMap) {
    this.productUnitAndPriceMap = productUnitAndPriceMap;
  }

  public Map<String, ProductPricingFlatVo> getProductPricingMap() {
    return productPricingMap;
  }

  public void setProductPricingMap(Map<String, ProductPricingFlatVo> productPricingMap) {
    this.productPricingMap = productPricingMap;
  }

  public Set<ProductUnitAndPrice> getProductUnitAndPrices() {
    return productUnitAndPrices;
  }

  public void setProductUnitAndPrices(Set<ProductUnitAndPrice> productUnitAndPrices) {
    this.productUnitAndPrices = productUnitAndPrices;
  }

  public Map<String, ProductUnitSpecificationAndPriceFlatVo> getProductUnitSpecificationAndPriceFlatDtoMap() {
    return productUnitSpecificationAndPriceFlatDtoMap;
  }

  public void setProductUnitSpecificationAndPriceFlatDtoMap(Map<String, ProductUnitSpecificationAndPriceFlatVo> productUnitSpecificationAndPriceFlatDtoMap) {
    this.productUnitSpecificationAndPriceFlatDtoMap = productUnitSpecificationAndPriceFlatDtoMap;
  }
}
