package com.bizunited.empower.business.product.optimize.vo;

import com.bizunited.empower.business.product.entity.ProductBarCodeInfo;
import com.bizunited.empower.business.product.entity.ProductUnitSpecificationAndPrice;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

/**
 * ProductSpecificationFlatVo 优化商品模块使用 - 扁平化商品规格信息
 *
 * @Author: hefan
 * @Date: 2021/6/11 15:31
 */
public class ProductSpecificationFlatVo implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 5243002187038682826L;

  // ------------------------------------
  /**
   * 规格编号
   */
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /**
   * 起订量
   */
  @ApiModelProperty("起订量")
  private BigDecimal minimumOrderQuantity;

  /**
   * 限定量
   */
  @ApiModelProperty("限定量")
  private BigDecimal maximumOrderQuantity;

  /**
   * 主图路径
   */
  @ApiModelProperty("主图路径")
  private String mainImagePath;

  /**
   * 主图名称
   */
  @ApiModelProperty("主图名称")
  private String mainImageName;

  /** 条形码 */
  @ApiModelProperty("条形码")
  private Set<ProductBarCodeInfo> productBarCodeInfos;

  /**
   * 单位规格价格
   */
  @ApiModelProperty("单位规格价格")
  private Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices;

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public BigDecimal getMinimumOrderQuantity() {
    return minimumOrderQuantity;
  }

  public void setMinimumOrderQuantity(BigDecimal minimumOrderQuantity) {
    this.minimumOrderQuantity = minimumOrderQuantity;
  }

  public BigDecimal getMaximumOrderQuantity() {
    return maximumOrderQuantity;
  }

  public void setMaximumOrderQuantity(BigDecimal maximumOrderQuantity) {
    this.maximumOrderQuantity = maximumOrderQuantity;
  }

  public String getMainImagePath() {
    return mainImagePath;
  }

  public void setMainImagePath(String mainImagePath) {
    this.mainImagePath = mainImagePath;
  }

  public String getMainImageName() {
    return mainImageName;
  }

  public void setMainImageName(String mainImageName) {
    this.mainImageName = mainImageName;
  }

  public Set<ProductBarCodeInfo> getProductBarCodeInfos() {
    return productBarCodeInfos;
  }

  public void setProductBarCodeInfos(Set<ProductBarCodeInfo> productBarCodeInfos) {
    this.productBarCodeInfos = productBarCodeInfos;
  }

  public Set<ProductUnitSpecificationAndPrice> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }
}
