package com.bizunited.empower.business.product.optimize.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * ProductUnitSpecificationAndPriceFlatVo 优化商品模块使用 - 扁平化商品单位规格和价格
 *
 * @Author: hefan
 * @Date: 2021/6/11 15:31
 */
public class ProductUnitSpecificationAndPriceFlatVo implements Serializable {

  /** 单位编号 */
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位名称 */
  @ApiModelProperty("单位名称")
  private String unitName;

  /**
   * 规格编码
   */
  @ApiModelProperty("规格编码")
  private String productSpecificationCode;

  /**
   * 规格名称
   */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 状态 1正常, 0禁用(枚举). **/
  @SaturnColumn(description="启用/禁用")
  private Integer tstatus = 1;

  /** 是基本单位 */
  @ApiModelProperty("是基本单位")
  private Boolean isBasicUnit;

  /** 允许购买 */
  @ApiModelProperty("允许购买")
  private Boolean allowPurchase;

  /** 默认购买 */
  @ApiModelProperty("默认购买")
  private Boolean defaultPurchase;

  /** 换算比例 */
  @ApiModelProperty("换算比例")
  private BigDecimal conversionRatio;

  /** 参考进货价 */
  @ApiModelProperty("参考进货价")
  private BigDecimal referencePurchasePrice;

  /** 销售价 */
  @ApiModelProperty("销售价")
  private BigDecimal sellingPrice;

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Boolean getBasicUnit() {
    return isBasicUnit;
  }

  public void setBasicUnit(Boolean basicUnit) {
    isBasicUnit = basicUnit;
  }

  public Boolean getAllowPurchase() {
    return allowPurchase;
  }

  public void setAllowPurchase(Boolean allowPurchase) {
    this.allowPurchase = allowPurchase;
  }

  public Boolean getDefaultPurchase() {
    return defaultPurchase;
  }

  public void setDefaultPurchase(Boolean defaultPurchase) {
    this.defaultPurchase = defaultPurchase;
  }

  public BigDecimal getConversionRatio() {
    return conversionRatio;
  }

  public void setConversionRatio(BigDecimal conversionRatio) {
    this.conversionRatio = conversionRatio;
  }

  public BigDecimal getReferencePurchasePrice() {
    return referencePurchasePrice;
  }

  public void setReferencePurchasePrice(BigDecimal referencePurchasePrice) {
    this.referencePurchasePrice = referencePurchasePrice;
  }

  public BigDecimal getSellingPrice() {
    return sellingPrice;
  }

  public void setSellingPrice(BigDecimal sellingPrice) {
    this.sellingPrice = sellingPrice;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }
}
