package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductBarCodeInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * ProductBarCodeInfo业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductBarCodeInfoRepository")
public interface ProductBarCodeInfoRepository
    extends
    JpaRepository<ProductBarCodeInfo, String>
    , JpaSpecificationExecutor<ProductBarCodeInfo> {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productBarCodeInfo from ProductBarCodeInfo productBarCodeInfo "
      + " where productBarCodeInfo.id=:id ")
  ProductBarCodeInfo findDetailsById(@Param("id") String id);

  /**
   * 根据租户编码、规格编码、单位编码查询
   *
   * @param tenantCode
   * @param productSpecificationCode
   * @param unitCode
   * @return
   */
  @Query("select pbc from ProductBarCodeInfo pbc inner join pbc.productSpecification ps " +
      " where ps.tenantCode = :tenantCode " +
      " and ps.productSpecificationCode = :productSpecificationCode " +
      " and pbc.unitCode = :unitCode")
  ProductBarCodeInfo findByTenantCodeAndProductSpecificationCodeAndUnitCode(@Param("tenantCode") String tenantCode, @Param("productSpecificationCode") String productSpecificationCode, @Param("unitCode") String unitCode);

  /**
   * 删除这个租户，商品规格，条码的ids集合之外的数据
   *
   * @param productSpecificationCode
   * @param tenantCode
   * @param ids
   */
  @Query(value = "FROM ProductBarCodeInfo uap join uap.productSpecification ps" +
      " WHERE uap.tenantCode = :tenantCode and ps.productSpecificationCode=:productSpecificationCode " +
      " and uap.id not in(:ids)")
  Set<ProductBarCodeInfo> findByProductSpecificationAndIdNotIn(@Param("tenantCode") String tenantCode, @Param("productSpecificationCode") String productSpecificationCode, @Param("ids") List<String> ids);

  /**
   * 这个租户，商品规格，条码的数据
   *
   * @param productSpecificationCode
   * @param tenantCode
   */
  @Query(value = "FROM ProductBarCodeInfo uap join uap.productSpecification ps" +
      " WHERE uap.tenantCode = :tenantCode and ps.productSpecificationCode=:productSpecificationCode ")
  Set<ProductBarCodeInfo> findByProductSpecification(@Param("tenantCode") String tenantCode, @Param("productSpecificationCode") String productSpecificationCode);

  /**
   * 通过条形码查询数量
   * @param barCode
   * @param tenantCode
   * @return
   */
  Integer countByBarCodeAndTenantCode(@Param("barCode") String barCode, @Param("tenantCode") String tenantCode);

  /**
   * 通过条形码 和id 查询非当前ID的数量
   * @param barCode
   * @param tenantCode
   * @param id
   * @return
   */
  Integer countByBarCodeAndTenantCodeAndIdNot(@Param("barCode")  String barCode, @Param("tenantCode")  String tenantCode, @Param("id") String id);

}