package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductBrand;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * ProductBrand业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductBrandRepository")
public interface ProductBrandRepository
    extends
    JpaRepository<ProductBrand, String>
    , JpaSpecificationExecutor<ProductBrand> {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productBrand from ProductBrand productBrand "
      + " where productBrand.id=:id ")
  ProductBrand findDetailsById(@Param("id") String id);

  @Query(" from ProductBrand f where f.brandCode = :brandCode and f.tenantCode=:tenantCode")
  ProductBrand findByBrandCode(@Param("brandCode") String brandCode, @Param("tenantCode") String tenantCode);


  /**
   * 根据品牌名称，租户
   * @param brandName
   * @param tenantCode
   * @return
   */
  List<ProductBrand> findByBrandNameAndTenantCode(String brandName, String tenantCode);



  /**
   * 分页查询，根据租户，创建时间倒序
   * @param tenantCode
   * @param pageable
   * @return
   */
  Page<ProductBrand> findByTenantCodeAndBrandNameContainingOrderByCreateTimeDesc(String tenantCode, String brandName ,Pageable pageable);

  /**
   * 查询当前租户的所有品牌信息
   * @param tenantCode
   * @return
   */
  List<ProductBrand> findByTenantCode(String tenantCode);

  /**
   * 根据品牌编号，租户
   * @param parentCode
   * @param tenantCode
   * @return
   */
  ProductBrand findByBrandCodeAndTenantCode(String parentCode, String tenantCode);

  /**
   * 根据一批编码code查询
   * @param tenantCode
   * @param codeList
   * @return
   */
  List<ProductBrand> findByTenantCodeAndBrandCodeIn(String tenantCode, List<String> codeList);
}