package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductDescription;

import java.lang.String;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ProductDescription业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductDescriptionRepository")
public interface ProductDescriptionRepository
    extends
    JpaRepository<ProductDescription, String>
    , JpaSpecificationExecutor<ProductDescription> {
  /**
   * 按照商品编号进行详情查询（包括关联信息）
   *
   * @param productCode 商品编号
   */
  @Query("select distinct productDescription from ProductDescription productDescription "
      + " left join fetch productDescription.product productDescription_product "
      + " where productDescription_product.tenantCode=:tenantCode and productDescription_product.productCode = :productCode")
  ProductDescription findDetailsByProduct(@Param("productCode") String productCode, @Param("tenantCode") String tenantCode);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productDescription from ProductDescription productDescription "
      + " where productDescription.id=:id ")
  ProductDescription findDetailsById(@Param("id") String id);

  /**
   * 根据租户，商品编码查询商品描述
   * @param tenantCode
   * @param productCode
   * @return
   */
  @Query("select distinct productDescription from ProductDescription productDescription "
      + " left join fetch productDescription.product productDescription_product "
      + " where productDescription.tenantCode=:tenantCode and productDescription_product.productCode=:productCode ")
  ProductDescription findByTenantCodeAndProductCode(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode);


  /**
   * 根据租户，商品ID进行查询描述信息的条数
   * @param tenantCode
   * @param productId
   * @return
   */
  @Query(value = "select COUNT(*) from product_description where tenant_code =:tenantCode and product_id =:productId",nativeQuery = true)
  Long countProductDescriptionByTenantCodeAndProductId(@Param("tenantCode") String tenantCode, @Param("productId") String productId);

}
