package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductFile;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * ProductFile业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductFileRepository")
public interface ProductFileRepository
    extends
    JpaRepository<ProductFile, String>
    , JpaSpecificationExecutor<ProductFile> {
  /**
   * 按照商品编号进行详情查询（包括关联信息）
   *
   * @param product 商品编号
   */
  @Query("select distinct productFile from ProductFile productFile "
      + " left join fetch productFile.product productFile_product "
      + " where productFile_product.id = :id and productFile_product.tenantCode=:tenantCode")
  Set<ProductFile> findDetailsByProduct(@Param("id") String id, @Param("tenantCode") String tenantCode);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productFile from ProductFile productFile "
      + " left join fetch productFile.product productFile_product "
      + " where productFile.id=:id ")
  ProductFile findDetailsById(@Param("id") String id);

  /**
   * 这个租户的这个商品的ids集合之外的数据
   *
   * @param productCode
   * @param ids
   */
  @Query(value = "FROM ProductFile uap " +
      " WHERE uap.tenantCode = :tenantCode and uap.product.productCode=:productCode " +
      " and uap.id not in(:ids)")
  Set<ProductFile> findByProductAndIdNotIn(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode, @Param("ids") List<String> ids);

  /**
   * 这个租户的这个商品的数据
   *
   * @param productCode
   */
  @Query(value = "FROM ProductFile uap " +
      " WHERE uap.tenantCode = :tenantCode and uap.product.productCode=:productCode ")
  Set<ProductFile> findByProduct(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode);


  /**
   * 通过商品ID 获取当前商品主图对象
   * @param productId
   * @param isMainImage
   * @return
   */
  ProductFile findByProductIdAndIsMainImage(@Param("productId") String productId, @Param("isMainImage") Boolean isMainImage);

  /**
   * 获取商品下图片数量
   * @param productId
   * @return
   */
  Integer countByProductId(@Param("productId") String productId);

  /**
   * 查询资源图是否已使用
   * @param resourceId
   * @return
   */
  int countByProductImageResourceId(@Param("resourceId") String resourceId);

  /**
   * 查询资源图是否已使用 排除传入的ID
   * @param resourceId
   * @param id
   * @return
   */
  int countByProductImageResourceIdAndIdNot(@Param("resourceId") String resourceId, @Param("id") String id);

}