package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductImageResource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * ProductImageResource业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductImageResourceRepository")
public interface ProductImageResourceRepository
    extends
    JpaRepository<ProductImageResource, String>
    , JpaSpecificationExecutor<ProductImageResource> {
  /**
   * 按照商品编号进行详情查询（包括关联信息）
   *
   * @param product 商品编号
   */
  @Query("select distinct productImageResource from ProductImageResource productImageResource "
      + " left join fetch productImageResource.product productImageResource_product "
      + " where productImageResource_product.id = :id")
  Set<ProductImageResource> findDetailsByProduct(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productImageResource from ProductImageResource productImageResource "
      + " left join fetch productImageResource.product productImageResource_product "
      + " where productImageResource.id=:id ")
  ProductImageResource findDetailsById(@Param("id") String id);

  /**
   * 通过商品ID查询资源库信息
   * @param productId
   * @return
   */
  @Query("from ProductImageResource pir " +
      "where pir.product.id =:productId")
  List<ProductImageResource> findByProductId(@Param("productId") String productId);

  /**
   * 通过商品ID+是否使用查询资源库信息
   * @param productId
   * @param useImage
   * @return
   */
  @Query("from ProductImageResource pir " +
      "where pir.product.id =:productId and pir.useImage=:useImage")
  List<ProductImageResource> findByProductIdAndUseImage(@Param("productId") String productId, @Param("useImage") Boolean useImage);


}