package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductMultipleSpecification;

import java.lang.String;
import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ProductMultipleSpecification业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductMultipleSpecificationRepository")
public interface ProductMultipleSpecificationRepository
    extends
    JpaRepository<ProductMultipleSpecification, String>
    , JpaSpecificationExecutor<ProductMultipleSpecification> {
  /**
   * 按照商品编码进行详情查询（包括关联信息）
   *
   * @param product 商品编码
   */
  @Query("select distinct productMultipleSpecification from ProductMultipleSpecification productMultipleSpecification "
      + " left join fetch productMultipleSpecification.product productMultipleSpecification_product "
      + " where productMultipleSpecification_product.id = :id and productMultipleSpecification_product.tenantCode=:tenantCode")
  Set<ProductMultipleSpecification> findDetailsByProduct(@Param("id") String id, @Param("tenantCode") String tenantCode);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productMultipleSpecification from ProductMultipleSpecification productMultipleSpecification "
      + " left join fetch productMultipleSpecification.product productMultipleSpecification_product "
      + " where productMultipleSpecification.id=:id ")
  ProductMultipleSpecification findDetailsById(@Param("id") String id);

  /**
   * 查询这个租户的这个商品的ids集合之外的数据
   *
   * @param productCode
   * @param ids
   */
  @Query(value = "FROM ProductMultipleSpecification uap " +
      " WHERE uap.tenantCode = :tenantCode and uap.product.productCode=:productCode " +
      " and uap.id not in(:ids)")
  Set<ProductMultipleSpecification> findByProductAndIdNotIn(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode, @Param("ids") List<String> ids);

  /**
   * 查询这个租户的这个商品的数据
   *
   * @param productCode
   */
  @Query(value = "FROM ProductMultipleSpecification uap " +
      " WHERE uap.tenantCode = :tenantCode and uap.product.productCode=:productCode ")
  Set<ProductMultipleSpecification> findByProduct(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode);
}