package com.bizunited.empower.business.product.repository;
import com.bizunited.empower.business.product.entity.ProductPriceModifyLog;
import com.bizunited.empower.business.product.repository.internal.ProductPriceModifyLogRepositoryCustom;
import java.lang.String;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ProductPriceModifyLog业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_ProductPriceModifyLogRepository")
public interface ProductPriceModifyLogRepository
    extends
      JpaRepository<ProductPriceModifyLog, String>
      ,JpaSpecificationExecutor<ProductPriceModifyLog>
      ,ProductPriceModifyLogRepositoryCustom 
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct productPriceModifyLog from ProductPriceModifyLog productPriceModifyLog "
      + " where productPriceModifyLog.id=:id ")
  ProductPriceModifyLog findDetailsById(@Param("id") String id);



}