package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductPricing;

import java.lang.String;
import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ProductPricing业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductPricingRepository")
public interface ProductPricingRepository
    extends
    JpaRepository<ProductPricing, String>
    , JpaSpecificationExecutor<ProductPricing> {
  /**
   * 按照商品编号进行详情查询（包括关联信息）
   *
   * @param id
   */
  @Query("select distinct productPricing from ProductPricing productPricing "
      + " left join fetch productPricing.product productPricing_product "
      + " where productPricing_product.id = :id and productPricing_product.tenantCode=:tenantCode")
  Set<ProductPricing> findDetailsByProduct(@Param("id") String id, @Param("tenantCode") String tenantCode);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productPricing from ProductPricing productPricing "
      + " left join fetch productPricing.product productPricing_product "
      + " where productPricing.id=:id ")
  ProductPricing findDetailsById(@Param("id") String id);

  @Query("select distinct productPricing from ProductPricing productPricing "
      + " left join fetch productPricing.product productPricing_product "
      + " where productPricing.tenantCode=:tenantCode and productPricing.customerCode=:customerCode "
      + " and productPricing_product.productCode =:productCode ")
  List<ProductPricing> findByTenantCodeAndProductCodeAndCustomerCode(@Param("tenantCode")String tenantCode, @Param("productCode") String productCode, @Param("customerCode") String customerCode);

  /**
   * 删除这个租户的这个商品的ids集合之外的数据
   * @param productCode
   * @param ids
   */
  @Query(value = "FROM ProductPricing productPricing " +
      " left join fetch productPricing.productPricingUnitSpecifications productPricing_productPricingUnitSpecifications " +
      " WHERE productPricing.tenantCode = :tenantCode and productPricing.product.productCode=:productCode " +
      " and productPricing.id not in(:ids) and productPricing.productSpecification.productSpecificationCode =:productSpecificationCode")
  Set<ProductPricing> findByProductAndIdNotInAndProductSpecification(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode, @Param("ids") List<String> ids, @Param("productSpecificationCode") String productSpecificationCode);

  /**
   * 这个租户的这个商品的数据
   * @param productCode
   */
  @Query(value = "FROM ProductPricing productPricing " +
      " left join fetch productPricing.productPricingUnitSpecifications productPricing_productPricingUnitSpecifications " +
      " WHERE productPricing.tenantCode = :tenantCode and productPricing.product.productCode=:productCode and productPricing.productSpecification.productSpecificationCode =:productSpecificationCode")
  Set<ProductPricing> findByProductAndProductSpecification(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode, @Param("productSpecificationCode") String productSpecificationCode);


  /**
   * 通过客户编码查询客户定价信息
   * @param customerCode
   * @param tenantCode
   * @return
   */
  @Query("select distinct productPricing from ProductPricing productPricing " +
      "left join fetch productPricing.product product " +
      "left join fetch product.productBrand productBrand " +
      "left join fetch product.productCategory productCategory " +
      "left join fetch product.productUnitAndPrices productUnitAndPrices " +
      "left join fetch productUnitAndPrices.productUnit productUnit " +
      "where productPricing.customerCode=:customerCode and productPricing.tenantCode=:tenantCode")
  List<ProductPricing> findByCustomerCodeAndTenantCode(@Param("customerCode") String customerCode, @Param("tenantCode") String tenantCode);
}