package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductPricingUnit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

@Repository("_ProductPricingUnitRepository")
public interface ProductPricingUnitRepository extends
    JpaRepository<ProductPricingUnit, String>
    , JpaSpecificationExecutor<ProductPricingUnit> {

  /**
   * 这个租户，定价ID，查询单位定价的数据
   *
   * @param productPricingId
   * @param tenantCode
   */
  @Query(value = "FROM ProductPricingUnit uap join uap.productPricing ps" +
      " WHERE uap.tenantCode = :tenantCode and ps.id=:productPricingId ")
  Set<ProductPricingUnit> findByProductPricing(@Param("tenantCode") String tenantCode, @Param("productPricingId") String productPricingId);

  /**
   * 删除这个租户，商品规格，条码的ids集合之外的数据
   *
   * @param productPricingId
   * @param tenantCode
   * @param ids
   */
  @Query(value = "FROM ProductPricingUnit uap join uap.productPricing ps" +
      " WHERE uap.tenantCode = :tenantCode and ps.id=:productPricingId " +
      " and uap.id not in(:ids)")
  Set<ProductPricingUnit> findByProductPricingAndIdNotIn(@Param("tenantCode") String tenantCode, @Param("productPricingId") String productPricingId, @Param("ids") List<String> ids);
}
