package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductPricingUnitSpecification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

@Repository("_ProductPricingUnitSpecificationRepository")
public interface ProductPricingUnitSpecificationRepository extends
    JpaRepository<ProductPricingUnitSpecification, String>
    , JpaSpecificationExecutor<ProductPricingUnitSpecification> {


  /**
   * 查询规格定价信息
   * @param productSpecificationCode
   * @param tenantCode
   * @return
   */
  Set<ProductPricingUnitSpecification> findByProductSpecificationCodeAndTenantCode(@Param("productSpecificationCode") String productSpecificationCode, @Param("tenantCode") String tenantCode);

  /**
   * 通过规格编号集合查询定价信息
   * @param productSpecificationCodes
   * @param tenantCode
   * @return
   */
  Set<ProductPricingUnitSpecification> findByProductSpecificationCodeInAndTenantCode(@Param("productSpecificationCodes") List<String> productSpecificationCodes, @Param("tenantCode") String tenantCode);

  /**
   * 这个租户，定价ID，查询单位定价的数据
   *
   * @param productPricingId
   * @param tenantCode
   */
  @Query(value = "FROM ProductPricingUnitSpecification uap join uap.productPricing ps" +
      " WHERE uap.tenantCode = :tenantCode and ps.id=:productPricingId and uap.productSpecificationCode=:productSpecificationCode")
  List<ProductPricingUnitSpecification> findByProductPricingAndProductSpecificationCode(@Param("tenantCode") String tenantCode, @Param("productPricingId") String productPricingId, @Param("productSpecificationCode") String productSpecificationCode);


}
