package com.bizunited.empower.business.product.repository;
import com.bizunited.empower.business.product.entity.ProductShowCategory;
import java.lang.String;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ProductShowCategory业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_ProductShowCategoryRepository")
public interface ProductShowCategoryRepository
    extends
      JpaRepository<ProductShowCategory, String>
      ,JpaSpecificationExecutor<ProductShowCategory>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct productShowCategory from ProductShowCategory productShowCategory "
      + " where productShowCategory.id=:id ")
  ProductShowCategory findDetailsById(@Param("id") String id);

    /**
     * 按照分类编码进行查询
     *
     * @param code 分类编码
     */
    @Query(" from ProductShowCategory f where f.code = :code and f.tenantCode=:tenantCode")
    ProductShowCategory findByCode(@Param("code") String code, @Param("tenantCode") String tenantCode);

    /**
     * 根据租户和父级编码查询
     * @param parentCode
     * @param tenantCode
     * @return
     */
    @Query(" from ProductShowCategory f where f.parentCode = :parentCode and f.tenantCode = :tenantCode order by f.createTime desc " )
    List<ProductShowCategory> findByParentCode(@Param("parentCode") String parentCode, @Param("tenantCode") String tenantCode);

    /**
     * 根据分类名称，租户查询
     * @param name
     * @param tenantCode
     * @return
     */
    List<ProductShowCategory> findByNameAndTenantCode(String name, String tenantCode);

    /**
     * 根据层级，租户查询
     * @param i
     * @param tenantCode
     * @return
     */
    List<ProductShowCategory> findByLevelAndTenantCode(int i, String tenantCode);

    /**
     * 分页查询，条件：租户，排序：创建时间倒叙
     * @param tenantCode
     * @param pageable
     * @return
     */
    Page<ProductShowCategory> findByTenantCodeOrderByCreateTimeDesc(String tenantCode, Pageable pageable);

    /**
     * 根据租户查询所有信息
     * @param tenantCode
     * @return
     */
    List<ProductShowCategory> findByTenantCode(String tenantCode);

    /**
     * 根据层级，租户查询 并以时间倒叙
     * @param level 层级
     * @param tenantCode 租户
     * @return
     */
    List<ProductShowCategory> findByLevelAndTenantCodeOrderByCreateTimeDesc(int level, String tenantCode);

    /**
     * 根据分类编码，租户查询
     * @param parentCode
     * @param tenantCode
     * @return
     */
    ProductShowCategory findByCodeAndTenantCode(String parentCode, String tenantCode);

    /**
     * 根据分类编号集合查询
     * @param tenantCode
     * @param codeList
     * @return
     */
    List<ProductShowCategory> findByTenantCodeAndCodeIn(String tenantCode, List<String> codeList);

}