package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductUnit;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * ProductUnit业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductUnitRepository")
public interface ProductUnitRepository
    extends
    JpaRepository<ProductUnit, String>
    , JpaSpecificationExecutor<ProductUnit> {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productUnit from ProductUnit productUnit "
      + " where productUnit.id=:id ")
  ProductUnit findDetailsById(@Param("id") String id);

  /**
   * 查询：条件：租户，单位名称
   * @param unitName
   * @param tenantCode
   * @return
   */
  List<ProductUnit> findByUnitNameAndTenantCode(String unitName, String tenantCode);

  /**
   * 查询：条件：id集合
   * @param ids
   * @return
   */
  Set<ProductUnit> findByIdIn(String[] ids);

  /**
   * 分页查询：条件：租户，单位名称（模糊）；排序：单位编码
   * @param tenantCode
   * @param unitName
   * @param pageable
   * @return
   */
  Page<ProductUnit> findByTenantCodeAndUnitNameContainingOrderByCreateTimeDescUnitCode(String tenantCode,String unitName, Pageable pageable);

  /**
   * 根据商品编码和单位查询单位信息
   * @param productCode
   * @param unitCode
   * @return
   */
  @Query("select pu from ProductUnit pu " +
      " inner join pu.productUnitSpecificationAndPrices pup " +
      " inner join pup.product p " +
      " where p.tenantCode= :tenantCode " +
      " and p.productCode = :productCode " +
      " and pu.unitCode = :unitCode")
  ProductUnit findByProductCodeAndUnitCode(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode, @Param("unitCode") String unitCode);

  /**
   * 根据启用状态查询
   *
   * @return
   */
  List<ProductUnit> findByTstatusAndTenantCode(Integer tstatus, String tenantCode);

  /**
   * 根据单位code集合查询
   * @param tenantCode
   * @param unitCodeList
   * @return
   */
  List<ProductUnit> findByTenantCodeAndUnitCodeIn(String tenantCode, List<String> unitCodeList);
}