package com.bizunited.empower.business.product.repository;

import com.bizunited.empower.business.product.entity.ProductUnitSpecificationAndPrice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ProductUnitAndPrice业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ProductUnitSpecificationAndPriceRepository")
public interface ProductUnitSpecificationAndPriceRepository
    extends
    JpaRepository<ProductUnitSpecificationAndPrice, String>
    , JpaSpecificationExecutor<ProductUnitSpecificationAndPrice> {
  /**
   * 按照商品编号进行详情查询（包括关联信息）
   */
  @Query("select distinct productUnitAndPrice from ProductUnitSpecificationAndPrice productUnitAndPrice "
      + " left join fetch productUnitAndPrice.product productUnitAndPrice_product "
      + " left join fetch productUnitAndPrice.productUnit productUnitAndPrice_productUnit "
      + " where productUnitAndPrice_product.id = :id")
  Set<ProductUnitSpecificationAndPrice> findDetailsByProduct(@Param("id") String id);

  /**
   * 按照单位编号进行详情查询（包括关联信息）
   */
  @Query("select distinct productUnitAndPrice from ProductUnitSpecificationAndPrice productUnitAndPrice "
      + " left join fetch productUnitAndPrice.product productUnitAndPrice_product "
      + " left join fetch productUnitAndPrice.productUnit productUnitAndPrice_productUnit "
      + " where productUnitAndPrice_productUnit.id = :id and productUnitAndPrice_product.tenantCode=:tenantCode")
  Set<ProductUnitSpecificationAndPrice> findDetailsByProductUnit(@Param("id") String id, @Param("tenantCode") String tenantCode);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct productUnitAndPrice from ProductUnitSpecificationAndPrice productUnitAndPrice "
      + " left join fetch productUnitAndPrice.product productUnitAndPrice_product "
      + " left join fetch productUnitAndPrice.productUnit productUnitAndPrice_productUnit "
      + " where productUnitAndPrice.id=:id ")
  ProductUnitSpecificationAndPrice findDetailsById(@Param("id") String id);

  @Query("select distinct productUnitAndPrice from ProductUnitSpecificationAndPrice productUnitAndPrice "
      + " left join fetch productUnitAndPrice.product productUnitAndPrice_product "
      + " where productUnitAndPrice.tenantCode=:tenantCode  "
      + " and  productUnitAndPrice_product.productCode in (:productCodeList) "
      + " and  productUnitAndPrice.isBasicUnit=:basicUnit ")
  List<ProductUnitSpecificationAndPrice> findByTenantCodeAndProductCodeInAndIsBasicUnit(@Param("tenantCode") String tenantCode, @Param("productCodeList") List<String> productCodeList, @Param("basicUnit") boolean basicUnit);

  @Query("select productUnitAndPrice from ProductUnitSpecificationAndPrice productUnitAndPrice "
      + " left join fetch productUnitAndPrice.product productUnitAndPrice_product "
      + " left join fetch productUnitAndPrice.productUnit productUnitAndPrice_productUnit "
      + " where productUnitAndPrice.tenantCode=:tenantCode  "
      + " and  productUnitAndPrice_product.productCode=:productCode "
      + " and  productUnitAndPrice_productUnit.unitCode=:unitCode ")
  List<ProductUnitSpecificationAndPrice> findByProductCodeAndUnitCode(@Param("productCode") String productCode, @Param("tenantCode") String tenantCode, @Param("unitCode") String unitCode);

  /**
   * 根据商品规格编码查询基本单位
   *
   * @param tenantCode
   * @param specificationCode
   * @return
   */
  @Query(value = "FROM ProductUnitSpecificationAndPrice uap " +
      "left join fetch uap.productSpecification ps " +
      " WHERE uap.tenantCode = :tenantCode " +
      " and uap.isBasicUnit = 1 " +
      " and ps.productSpecificationCode = :specificationCode ")
  ProductUnitSpecificationAndPrice findBasicBySpecificationCode(@Param("tenantCode") String tenantCode, @Param("specificationCode") String specificationCode);

  /**
   * 这个租户的这个商品的数据
   *
   * @param productCode
   */
  @Query(value = "FROM ProductUnitSpecificationAndPrice uap " +
      "left join fetch uap.product p" +
      " WHERE uap.tenantCode = :tenantCode and p.productCode=:productCode and uap.productSpecification.productSpecificationCode =:specificationCode")
  List<ProductUnitSpecificationAndPrice> findByProductAndProductSpecification(@Param("tenantCode") String tenantCode, @Param("productCode") String productCode, @Param("specificationCode") String specificationCode);

  @Query(value = "select ps.product_specification_code , pu.unit_code  from product_unit_specification_and_price puap " +
      "left join  product p on p.id = puap.product_id " +
      "left join  product_unit pu on pu.id = puap.unit_id " +
      "left join  product_specification ps on ps.product_id = p.id " +
      "where puap.tenant_code = :tenantCode and ps.product_specification_code in( :specificationCodeList )", nativeQuery = true)
  List<Map<String, Object>> findSpecificationCodeAndUnitCodeBySpecificationCodeIn(@Param("tenantCode") String tenantCode, @Param("specificationCodeList") List<String> specificationCodeList);


  /**
   * 根据商品规格集合查询 商品规格、单位规格、销售价格
   * @param tenantCode
   * @param specificationCodeList
   * @return
   */
  @Query(value = "select ps.product_specification_code , pu.unit_code,puap.selling_price  from product_unit_specification_and_price puap " +
      "left join  product p on p.id = puap.product_id " +
      "left join  product_unit pu on pu.id = puap.unit_id " +
      "left join  product_specification ps on ps.product_id = p.id " +
      "where puap.tenant_code = :tenantCode and ps.product_specification_code in( :specificationCodeList )", nativeQuery = true)
  List<Map<String, Object>> findSpecAndUnitAndPriceBySpecificationCodeIn(@Param("tenantCode") String tenantCode, @Param("specificationCodeList") List<String> specificationCodeList);

  /**
   * 根据规格和单位查询销售价格
   * @param tenantCode
   * @param specificationCode
   * @param unitCode
   * @return
   */
  @Query(value = "FROM ProductUnitSpecificationAndPrice uap " +
      "left join fetch uap.productSpecification ps " +
      "left join fetch uap.productUnit pu " +
      " WHERE uap.tenantCode = :tenantCode " +
      " and pu.unitCode = :unitCode " +
      " and ps.productSpecificationCode = :specificationCode ")
  ProductUnitSpecificationAndPrice findBySpecificationCodeAndUnitCode(@Param("tenantCode") String tenantCode, @Param("specificationCode") String specificationCode, @Param("unitCode") String unitCode);


  /**
   * 通过规格编码查询规格价格信息
   * @param specificationId
   * @return
   */
  List<ProductUnitSpecificationAndPrice> findByProductSpecificationId(@Param("specificationId") String specificationId);
}