package com.bizunited.empower.business.product.repository.internal;

import com.bizunited.empower.business.product.common.enumerate.ShelfStatus;
import com.bizunited.empower.business.product.entity.ProductSpecification;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.script.context.InvokeParams;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProductSpecificationRepositoryImpl implements ProductSpecificationRepositoryCustom,PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  final static String SELECT_PRODUCTSPECIFICATION_HQL = "select distinct ps from ProductSpecification ps  where 1=1";
  final static String SELECT_PRODUCTSPECIFICATION_COUNT_HQL = "select count(distinct ps.id) FROM ProductSpecification ps where 1=1";

  @Override
  public Page<ProductSpecification> queryPage(Pageable pageable, InvokeParams conditions) {

    StringBuilder hql = new StringBuilder(SELECT_PRODUCTSPECIFICATION_HQL);
    StringBuilder countHql = new StringBuilder(SELECT_PRODUCTSPECIFICATION_COUNT_HQL);
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    if (conditions != null) {
      Map<String, Object> params = conditions.getInvokeParams();
      // 租户
      String tenantCode = (String) params.get("tenantCode");
      condition.append(" and ps.tenantCode =:tenantCode ");
      parameters.put("tenantCode", tenantCode);
      // 允销 商品规格编码集合  虽然变量名是productCodeList，但确认了内容传的是 productSpecificationCode
      String productCodeList = (String) params.get("productCodeList");
      if (StringUtils.isNotBlank(productCodeList)) {
        String[] split = productCodeList.split(",");
        List<String> productSpecificationCodeList = Arrays.asList(split);
        if (ArrayUtils.isNotEmpty(split)) {
          condition.append(" and ps.productSpecificationCode in( :productSpecificationCodeList )");
          parameters.put("productSpecificationCodeList", productSpecificationCodeList);
        }
      }
      // 商品编码/商品名称
      String productCode = (String) params.get("productCode");
      if (StringUtils.isNotBlank(productCode)) {
        condition.append(" and (ps.product.productCode like concat('%',:productCode,'%') " +
            "or ps.product.productName like concat('%',:productCode,'%') ) ");
        parameters.put("productCode", productCode);
      }
      // 上架状态
      condition.append(" and ps.product.shelfStatus =:shelfStatus ");
      parameters.put("shelfStatus", ShelfStatus.AVAILABLE_NOW.getStatus());
      // 品牌编码
      String brandCode = (String) params.get("brandCode");
      if (StringUtils.isNotBlank(brandCode)) {
        condition.append(" and ps.product.productBrand.brandCode =:brandCode ");
        parameters.put("brandCode", brandCode);
      }
      // 分类编码
      String categoryCode = (String) params.get("categoryCode");
      if (StringUtils.isNotBlank(categoryCode)) {
        condition.append(" and ps.product.productCategory.code =:categoryCode ");
        parameters.put("categoryCode", categoryCode);
      }
      // 分类快速编号
      String categoryFlatCode = (String) params.get("categoryFlatCode");
      if (StringUtils.isNotBlank(categoryFlatCode)) {
        condition.append(" and ps.product.productCategory.flatCode like concat(:categoryFlatCode,'%') ");
        parameters.put("categoryFlatCode", categoryFlatCode);
      }
    }
    hql.append(condition);
    // ===========排序============
    Sort sort = pageable.getSort();
    List<Sort.Order> orders = sort.get().collect(Collectors.toList());
    if (CollectionUtils.isNotEmpty(orders)) {
      hql.append(" order by ");
      for (int i = 0; i < orders.size(); i++) {
        Sort.Order order = orders.get(i);
        if (i > 0) {
          hql.append(",");
        }
        hql.append(" ps." + order.getProperty() + " ");
        hql.append(order.getDirection().toString());
      }
    } else {
      hql.append(" order by ps.createTime desc , ps.productSpecificationCode desc");
    }
    // =========================
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);

  }
}
