package com.bizunited.empower.business.product.service;

import com.bizunited.empower.business.product.dto.DiscountResultDto;
import com.bizunited.empower.business.product.dto.ProductSpecificationAndUnitDto;
import com.bizunited.empower.business.product.entity.ProductUnitSpecificationAndPrice;
import com.bizunited.empower.business.product.vo.ProductPriceVo;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

public interface ProductActionService {
  /**
   * 该部分商品原始价值计算
   * @param productCodeList
   * @return
   */
  List<ProductPriceVo> findProductSellingPrice(List<String> productCodeList);

  /**
   * 调用商品模块，检验单位编码的有效性
   * @param productCode
   * @param unitCode
   * @return
   */
  Boolean validityUnitCode(String productCode, String unitCode);

  /**
   * 该部分商品最终交易价计算
   * @param discountResultDtoList
   * @return
   */
  List<DiscountResultDto> findProductFinalPrice( List<DiscountResultDto> discountResultDtoList);

  /**
   * 校验一批商品规格编码是否在经销商内存在，只要要求验证的一批商品规格编号有一个不存在于经销商的品类中，就返回false
   * @param productSpecificationCodes 指定的一批商品规格业务编号
   * @return
   */
  Boolean validateSpecificationExist(List<String> productSpecificationCodes);

  /**
   * 根据 规格编码和单位编码 查询 各自名称，并按一对一的结构返回
   * pair 左:规格编码；右：单位编码
   * @param pairList
   * @return
   */
  ProductSpecificationAndUnitDto findSpecNameAndUnitName(List<Pair<String,String>> pairList);

  /**
   * 客户定价信息转换
   * @param customer
   * @param productUnitSpecificationAndPrices
   */
  void coverDiscountResults(String customer, Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices);

}
