package com.bizunited.empower.business.product.service;

import com.bizunited.empower.business.product.entity.ProductPricing;
import com.bizunited.empower.business.product.entity.ProductPricingUnitSpecification;
import com.bizunited.empower.business.product.entity.ProductSpecification;

import java.util.List;
import java.util.Set;

/**
 * ProductPricingUnitService 按单位给商品-客户定价的服务类
 *
 * @Author: hefan
 * @Date: 2021/4/2 13:53
 */
public interface ProductPricingUnitSpecificationService {

  /**
   * 通过规格编号 获取定价信息
   * @param productSpecificationCode
   * @return
   */
  Set<ProductPricingUnitSpecification> findByProductSpecificationCode(String productSpecificationCode);

  /**
   * 通过规格编号集合 查询规格定价信息
   * @param productSpecificationCodes
   * @return
   */
  Set<ProductPricingUnitSpecification> findByProductSpecificationCodes(List<String> productSpecificationCodes);
  /**
   * 绑定主表信息，并保存
   * @param productPricingUnitSpecifications
   * @param productPricing
   */
  void createInsertAbleEntitySet(Set<ProductPricingUnitSpecification> productPricingUnitSpecifications, ProductPricing productPricing, ProductSpecification productSpecification);

  /**
   * 批量删除
   * @param productPricingUnitSpecifications
   */
  void deleteByBatch(Set<ProductPricingUnitSpecification> productPricingUnitSpecifications);

  /**
   * 批量修改
   * @param productPricingUnitSpecifications
   * @param productPricing
   * @return
   */
  Set<ProductPricingUnitSpecification> updateFormBatch(Set<ProductPricingUnitSpecification> productPricingUnitSpecifications, ProductPricing productPricing,ProductSpecification productSpecification);

  /**
   * 批量保存
   * @param productPricingUnitSpecifications
   */
  void saveBatch(Set<ProductPricingUnitSpecification> productPricingUnitSpecifications);

}
