package com.bizunited.empower.business.product.service;

import com.bizunited.empower.business.product.dto.ProductDto;
import com.bizunited.empower.business.product.entity.Product;

import java.util.List;
import java.util.Set;

/**
 * Product业务模型的服务层接口定义
 * @author saturn
 */
public interface ProductService { 
  /**
   * 创建一个新的Product模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  Product create(ProductDto productDto);
  /**
   * 创建一个新的StudentEntity模型对象
   * 该代码由satrun骨架生成，默认不包括任何可能第三方系统调用、任何复杂逻辑处理等，主要应用场景为前端表单数据的暂存功能</br>
   * 该方法与本接口中的updateFrom方法呼应
   */
  Product createForm(ProductDto productDto);
  /**
   * 更新一个已有的Product模型对象，其主键属性必须有值(1.1.4-release版本调整)。
   * 这个方法实际上一共分为三个步骤（默认）：</br>
   * 1、调用updateValidation方法完成表单数据更新前的验证</br>
   * 2、调用updateForm方法完成表单数据的更新</br>
   * 3、完成开发人员自行在本update方法中书写的，进行第三方系统调用（或特殊处理过程）的执行。</br>
   * 这样做的目的，实际上是为了保证updateForm方法中纯粹是处理表单数据的，在数据恢复表单引擎默认调用updateForm方法时，不会影响任何第三方业务数据
   * （当然，如果系统有特别要求，可由开发人员自行完成代码逻辑调整）
   */
  Product update(ProductDto productDto);
  /**
   * 该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等
   * 该方法非常重要，因为如果进行静态表单的数据恢复，那么表单引擎将默认调用主业务模型（服务层）的这个方法。</br>
   * 这样一来保证了数据恢复时，不会涉及任何第三方系统的调用（当然，如果开发人员需要涉及的，可以自行进行修改）
   */
  Product updateForm(Product product);
  /**
   * fixme 目前商品是按需缓存，无法改造该方法
   * 按照关联的 商品分类进行详情查询（包括关联信息）
   * @param productCategory 关联的 商品分类
   */
  Set<Product> findDetailsByProductCategory(String productCategory);
  /**
   * fixme 目前商品是按需缓存，无法改造该方法
   * 按照关联的 品牌进行详情查询（包括关联信息）
   * @param productBrand 关联的 品牌
   */
  Set<Product> findDetailsByProductBrand(String productBrand);
  /**
   * fixme 目前商品是按需缓存，无法改造该方法
   * 按照关联的 商品标签进行详情查询（包括关联信息）
   * @param tags 关联的 商品标签
   */
  Set<Product> findDetailsByTags(String tags);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  Product findDetailsById(String id);
  /**
   * 按照Product的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  Product findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  void deleteById(String id);
  /**
   * 按照商品编码进行查询
   * @param productCode 商品编码
   */
  Product findByProductCode(String productCode);


  /**
   * 上架下架（修改上架状态 1，立即上架；2，暂不上架）
   * @param shelfStatus
   * @return
   */
  void updateShelfStatus(Integer shelfStatus, String productCode);

  /**
   * 根据商品编号集合查询
   * @param productCodeList
   * @return
   */
  List<Product> findByTenantCodeAndProductCodeIn(List<String> productCodeList);

  /**
   * 商品图片资源状态修改
   * @param productId
   */
  void updateImageResourceStatus(String productId);
}