package com.bizunited.empower.business.product.service;

import com.bizunited.empower.business.product.entity.Product;
import com.bizunited.empower.business.product.entity.ProductSpecification;
import com.bizunited.empower.business.product.entity.ProductUnitSpecificationAndPrice;
import com.bizunited.empower.business.product.vo.ProductSpecificationAndUnitPriceVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

/**
 * ProductUnitAndPrice业务模型的服务层接口定义
 * @author saturn
 */
public interface ProductUnitSpecificationAndPriceService {
  /**
   * 创建一个新的ProductUnitAndPrice模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  ProductUnitSpecificationAndPrice create(ProductUnitSpecificationAndPrice productUnitSpecificationAndPrice);
  /**
   * 创建一个新的StudentEntity模型对象
   * 该代码由satrun骨架生成，默认不包括任何可能第三方系统调用、任何复杂逻辑处理等，主要应用场景为前端表单数据的暂存功能</br>
   * 该方法与本接口中的updateFrom方法呼应
   */
  ProductUnitSpecificationAndPrice createForm(ProductUnitSpecificationAndPrice productUnitSpecificationAndPrice);
  /**
   * 更新一个已有的ProductUnitAndPrice模型对象，其主键属性必须有值(1.1.4-release版本调整)。
   * 这个方法实际上一共分为三个步骤（默认）：</br>
   * 1、调用updateValidation方法完成表单数据更新前的验证</br>
   * 2、调用updateForm方法完成表单数据的更新</br>
   * 3、完成开发人员自行在本update方法中书写的，进行第三方系统调用（或特殊处理过程）的执行。</br>
   * 这样做的目的，实际上是为了保证updateForm方法中纯粹是处理表单数据的，在数据恢复表单引擎默认调用updateForm方法时，不会影响任何第三方业务数据
   * （当然，如果系统有特别要求，可由开发人员自行完成代码逻辑调整）
   */
  ProductUnitSpecificationAndPrice update(ProductUnitSpecificationAndPrice productUnitSpecificationAndPrice);
  /**
   * 该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等
   * 该方法非常重要，因为如果进行静态表单的数据恢复，那么表单引擎将默认调用主业务模型（服务层）的这个方法。</br>
   * 这样一来保证了数据恢复时，不会涉及任何第三方系统的调用（当然，如果开发人员需要涉及的，可以自行进行修改）
   */
  ProductUnitSpecificationAndPrice updateForm(ProductUnitSpecificationAndPrice productUnitSpecificationAndPrice);
  /**
   * 按照关联的 商品编号进行详情查询（包括关联信息）
   * @param product 关联的 商品编号
   */
  Set<ProductUnitSpecificationAndPrice> findDetailsByProduct(String product);
  /**
   * 按照关联的 单位编号进行详情查询（包括关联信息）
   * @param productUnit 关联的 单位编号
   */
  Set<ProductUnitSpecificationAndPrice> findDetailsByProductUnit(String productUnit);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  ProductUnitSpecificationAndPrice findDetailsById(String id);
  /**
   * 按照ProductUnitAndPrice的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  ProductUnitSpecificationAndPrice findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  void deleteById(String id);

  /**
   * 生成可以入库的单位与价格实体集合
   * @param productUnitSpecificationAndPrices
   * @return
   */
  Set<ProductUnitSpecificationAndPrice> createInsertAbleEntitySet(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices, Product product, ProductSpecification productSpecification);

  /**
   * 批量删除
   * @param productUnitSpecificationAndPrices
   */
  void deleteByBatch(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices);

  /**
   * 批量修改
   * @param productUnitSpecificationAndPrices
   * @param current
   * @return
   */
  Set<ProductUnitSpecificationAndPrice> updateFormBatch(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices, Product current, ProductSpecification productSpecification);

  /**
   * 根据商品规格编码查询基本单位
   * @param specificationCode
   * @return
   */
  ProductUnitSpecificationAndPrice findBasicBySpecificationCode(String specificationCode);

  /**
   * 根据商品规格编码、单位编码查询价格
   * @param specificationCode
   * @return
   */
  ProductUnitSpecificationAndPrice findBySpecificationCodeAndUnitCode(String specificationCode, String unitCode);

  /**
   * 根据商品规格编码、单位编码、客户编码查询价格信息
   * @param specificationCode
   * @param unitCode
   * @param customerCode
   * @return
   */
  ProductUnitSpecificationAndPrice findBySpecificationCodeAndUnitCodeAndCustomerCode(String specificationCode, String unitCode,String customerCode);


  /**
   * left specCode  right unitCode
   * @param pairList
   * @return
   */
  ProductSpecificationAndUnitPriceVo findPriceBySpecUnitPairList(List<Pair<String, String>> pairList);

  /**
   * 获取单位最低价格 如果单位为空，那么返回基本单位最低销售价格
   * @param productUnitSpecificationAndPrices
   * @return
   */
  ProductUnitSpecificationAndPrice splitMinProice(Set<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices,String unitCode);

  /**
   * 标记当前价格集合中最低价格
   * @param productUnitSpecificationAndPrices
   * @return
   */
  Set<ProductUnitSpecificationAndPriceVo> markMinPrices(Set<ProductUnitSpecificationAndPriceVo> productUnitSpecificationAndPrices);

  /**
   * 通过规格ID 获取价格信息
   * @param specificationId
   * @return
   */
  List<ProductUnitSpecificationAndPrice> findBySpecification(String specificationId);

  /**
   * 批量保存价格信息
   * @param productUnitSpecificationAndPrices
   */
  void saveBatch(List<ProductUnitSpecificationAndPrice> productUnitSpecificationAndPrices);

}