package com.bizunited.empower.business.product.service;

import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.empower.business.product.vo.SaasProductVo;
import com.bizunited.platform.script.context.InvokeParams;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface ProductVoService {

  Page<ProductVo> findByConditions(Pageable pageable, InvokeParams conditions);

  /**
   * 商品图库列表分页查询
   * @param pageable
   * @param conditions
   * @return
   */
  Page<ProductVo> findImageResourceByConditions(Pageable pageable, InvokeParams conditions);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  ProductVo findDetailsById(String id);

  /**
   * 通过id查询商品详情，如果有客户编码，返回客户价格
   * @param id 商品主键
   * @param customerCode 客户编码
   * @return
   */
  ProductVo findDetailsByIdAndCustomerCode(String id,String customerCode);

  /**
   * fixme 改造内部，因为有注解，返回需要保持
   * 按照code进行详情查询（包括关联信息）
   * @param code
   */
  ProductVo findDetailsByProductCode(String code);


  /**
   * 按照code进行详情查询（包括关联信息）
   * 同时返回客户编码的可用库存信息
   * @param code
   * @param customerCode 客户编码
   */
  ProductVo findDetailsByProductCodeAndCustomerCode(String code,String customerCode);

  /**
   * 根据商品集合查询单位
   * @param productCodes
   * @return
   */
  List<ProductVo> findUnitByProductCodeList(List<String> productCodes);


  /**
   * 通过条形码 查询Saas系统商品库 规格信息
   * @param barCode
   * @return
   */
  SaasProductVo findSaasProductByBarCode(String barCode);

  /**
   * 通过条形码查询商品信息
   * @param barCode
   * @return
   */
  ProductVo findByBarCode(String barCode);

  /**
   * 通过规格编码查询商品信息
   * @param specificationId
   * @return
   */
  List<ProductVo> findBySpecificationCodes(List<String> specificationCodes);

}
