package com.bizunited.empower.business.product.service.handler;

import com.bizunited.empower.business.product.dto.DiscountResultDto;
import com.bizunited.empower.business.product.entity.ProductPricing;
import com.bizunited.empower.business.product.entity.ProductPricingUnitSpecification;
import com.bizunited.empower.business.product.repository.ProductPricingRepository;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 商品以确定客户直接定的价
 */
@Component("ProductCustomerPricingDiscountHandler")
public class ProductCustomerPricingDiscountHandler extends DiscountHandler {

  /**
   * true：结束责任链的传递，false：继续计算折算
   */
  private static ThreadLocal<Boolean> isOver = new ThreadLocal<>();

  @Autowired
  ProductPricingRepository productPricingRepository;

  @Override
  public List<DiscountResultDto> basedOnOriginalPrice(String customerCode, String productCode) {
    /**
     * 1.获取该客户在该商品上的定价
     */
    List<ProductPricing> productPricings = productPricingRepository.findByTenantCodeAndProductCodeAndCustomerCode(TenantUtils.getTenantCode(), productCode, customerCode);
    // 没有就返回
    if (CollectionUtils.isEmpty(productPricings)) {
      return null;
    }
    List<DiscountResultDto> currentBase = new ArrayList<>();
    for (ProductPricing productPricing : productPricings) {
      Set<ProductPricingUnitSpecification> productPricingUnitSpecifications = productPricing.getProductPricingUnitSpecifications();
      for (ProductPricingUnitSpecification productPricingUnitSpecification : productPricingUnitSpecifications) {
        DiscountResultDto current = new DiscountResultDto(customerCode, productCode);
        BigDecimal orderPrice = productPricingUnitSpecification.getOrderPrice();
        current.setAfterDiscountPrice(orderPrice);
        current.setUnitCode(productPricingUnitSpecification.getUnitCode());
        current.setProductSpecificationCode(productPricingUnitSpecification.getProductSpecificationCode());
        currentBase.add(current);
      }
    }
    return currentBase;
  }

  /**
   * 只要本轮价，抛弃之前的价格
   *
   * @param prevResult
   * @param currentBase
   * @return
   */
  @Override
  public List<DiscountResultDto> addUpDiscountResult(List<DiscountResultDto> prevResult, List<DiscountResultDto> currentBase) {
    if (CollectionUtils.isEmpty(currentBase)) {
      setOver(false);
      return prevResult;
    }
    setOver(true);
    return currentBase;
  }

  @Override
  public Boolean isOver() {
    return isOver.get();
  }

  private void setOver(Boolean over) {
    isOver.set(over);
  }
}
