package com.bizunited.empower.business.product.service.handler;

import com.bizunited.empower.business.product.dto.DiscountResultDto;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 商品-客户最终交易价-责任链-虚拟头部节点
 */
@Component("VirtualHeadDiscountHandler")
public class VirtualHeadDiscountHandler extends DiscountHandler {
  @Autowired
  private ApplicationContext applicationContext;
  
  @Override
  public List<DiscountResultDto> basedOnOriginalPrice(String customerCode, String productCode) {
    return null;
  }

  @Override
  public List<DiscountResultDto> addUpDiscountResult(List<DiscountResultDto> prev, List<DiscountResultDto> next) {
    return prev;
  }

  @Override
  public Boolean isOver() {
    return false;
  }

  /**
   * 检验，并使子类链闭环
   */
  @Override
  public final void validateClosedLoop() {
    //获取所有的继承了DiscountHandler的类
    Map<String, DiscountHandler> discountHandlerMap = applicationContext.getBeansOfType(DiscountHandler.class);
    //将类组成链
    DiscountHandler head = this;
    for (Map.Entry<String, DiscountHandler> entry : discountHandlerMap.entrySet()) {
      if ("VirtualHeadDiscountHandler".equals(entry.getKey())) {
        continue;
      }
      head.setDiscountHandler(entry.getValue());
      head = entry.getValue();
    }
  }
}
