package com.bizunited.empower.business.product.service.internal;

import com.bizunited.empower.business.product.entity.ProductBrand;
import com.bizunited.empower.business.product.repository.ProductBrandRepository;
import com.bizunited.empower.business.product.service.ProductBrandVoService;
import com.bizunited.empower.business.product.vo.ProductBrandVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Service("ProductBrandVoServiceImpl")
public class ProductBrandVoServiceImpl implements ProductBrandVoService {

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  ProductBrandRepository productBrandRepository;

  /**
   * 分页查询
   * @param pageable
   * @return
   */
  @Override
  public Page<ProductBrandVo> findByConditions(Pageable pageable, String brandName) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    brandName = StringUtils.isBlank(brandName) ? "" : brandName;
    Page<ProductBrand> rolePage = this.productBrandRepository.findByTenantCodeAndBrandNameContainingOrderByCreateTimeDesc(TenantUtils.getTenantCode(), brandName, pageable);
    if(CollectionUtils.isEmpty(rolePage.getContent())) {
      return Page.empty(pageable);
    }
    List<ProductBrand> content = rolePage.getContent();
    Collection<ProductBrandVo> products = this.nebulaToolkitService.copyCollectionByWhiteList(content, ProductBrand.class, ProductBrandVo.class, HashSet.class, ArrayList.class,
        "products");
    return new PageImpl<>(Lists.newArrayList(products), pageable, rolePage.getTotalElements());
  }
}
