package com.bizunited.empower.business.product.service.internal;

import com.bizunited.empower.business.product.entity.ProductCategory;
import com.bizunited.empower.business.product.repository.ProductCategoryRepository;
import com.bizunited.empower.business.product.service.ProductCategoryVoService;
import com.bizunited.empower.business.product.vo.ProductCategoryVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@Service("ProductCategoryVoServiceImpl")
public class ProductCategoryVoServiceImpl implements ProductCategoryVoService {

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  ProductCategoryRepository productCategoryRepository;

  @Override
  public List<ProductCategoryVo> findStructureTree() {

    List<ProductCategory> all = this.productCategoryRepository.findByTenantCode(TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(all)) {
      return Lists.newArrayList();
    }
    /**
     * 将品牌信息组装为父子树
     * 自己的flat - 自己的code = 父的flat
     */
    Collection<ProductCategoryVo> productBrandVos = this.nebulaToolkitService.copyCollectionByWhiteList(all, ProductCategory.class, ProductCategoryVo.class, HashSet.class, ArrayList.class);
    Map<String, Set<ProductCategoryVo>> collect = productBrandVos.stream().collect(Collectors.groupingBy((ProductCategoryVo vo) -> {
      String flatCode = vo.getFlatCode();
      String brandCode = vo.getCode();
      return flatCode.replace(brandCode, "");
    }, Collectors.toSet()));
    Set<ProductCategoryVo> topSet = collect.get("");
    List<ProductCategoryVo> topList = topSet.stream().sorted(Comparator.comparing(ProductCategoryVo::getCreateTime).reversed()).collect(Collectors.toList());
    for (ProductCategoryVo top : topList) {
      // 递归取子
      this.getChildren(top,collect);
    }
    return topList;
  }

  @SuppressWarnings({"unchecked", "rawtypes"})
  private void getChildren(ProductCategoryVo top, Map<String, Set<ProductCategoryVo>> collect) {
    Set<ProductCategoryVo> children = collect.get(top.getFlatCode());
    if (CollectionUtils.isEmpty(children)) {
      return;
    }
    Set<ProductCategoryVo> childrenTreeSet = new TreeSet(Comparator.comparing(ProductCategoryVo::getCreateTime).reversed());
    children.stream().forEach(productCategoryVo -> childrenTreeSet.add(productCategoryVo));
    for (ProductCategoryVo child : childrenTreeSet) {
      this.getChildren(child,collect);
    }
    top.setChildren(childrenTreeSet);
  }
}
