package com.bizunited.empower.business.product.service.internal;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.product.common.enumerate.AdjustType;
import com.bizunited.empower.business.product.common.enumerate.PriceType;
import com.bizunited.empower.business.product.entity.ProductPriceModifyLog;
import com.bizunited.empower.business.product.entity.ProductPricingUnitSpecification;
import com.bizunited.empower.business.product.entity.ProductUnitSpecificationAndPrice;
import com.bizunited.empower.business.product.repository.ProductPriceModifyLogRepository;
import com.bizunited.empower.business.product.service.ProductPriceModifyLogService;
import java.lang.Override;
import java.lang.String;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;

import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * ProductPriceModifyLog业务模型的服务层接口实现
 * @author saturn
 */
@Service("ProductPriceModifyLogServiceImpl")
public class ProductPriceModifyLogServiceImpl implements ProductPriceModifyLogService {
  @Autowired
  private ProductPriceModifyLogRepository productPriceModifyLogRepository;
  @Transactional
  @Override
  public ProductPriceModifyLog create(ProductPriceModifyLog productPriceModifyLog) {
    ProductPriceModifyLog current = this.createForm(productPriceModifyLog);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  }
  @Transactional
  @Override
  public ProductPriceModifyLog createForm(ProductPriceModifyLog productPriceModifyLog) {
   /*
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    Date now = new Date();
    productPriceModifyLog.setCreateAccount(SecurityUtils.getUserAccount());
    productPriceModifyLog.setCreateTime(now);
    productPriceModifyLog.setModifyAccount(SecurityUtils.getUserAccount());
    productPriceModifyLog.setModifyTime(now);

    this.createValidation(productPriceModifyLog);

    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================

    this.productPriceModifyLogRepository.save(productPriceModifyLog);
    // 返回最终处理的结果，里面带有详细的关联信息
    return productPriceModifyLog;
  }
  /**
   * 在创建一个新的ProductPriceModifyLog模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(ProductPriceModifyLog productPriceModifyLog) {
    Validate.notNull(productPriceModifyLog , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(productPriceModifyLog.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    productPriceModifyLog.setId(null);
    Validate.notBlank(productPriceModifyLog.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductCode(), "添加信息时，商品编码不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductName(), "添加信息时，商品名称不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductSpecificationCode(), "添加信息时，规格编号不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductSpecificationName(), "添加信息时，规格名称不能为空！");
    Validate.notBlank(productPriceModifyLog.getUnitCode(), "添加信息时，单位编号不能为空！");
    Validate.notBlank(productPriceModifyLog.getUnitName(), "添加信息时，单位名称不能为空！");
    Validate.notNull(productPriceModifyLog.getPriceType(), "添加信息时，价格类型 1.销售价 2.进货价不能为空！");
    Validate.notNull(productPriceModifyLog.getAdjustType(), "添加信息时，调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调不能为空！");
    Validate.notNull(productPriceModifyLog.getAdjustMoney(), "添加信息时，调整金额不能为空！");
    Validate.notNull(productPriceModifyLog.getOldMoney(), "添加信息时，调整前价格不能为空！");
    Validate.notNull(productPriceModifyLog.getAfterMoney(), "添加信息时，调整后金额不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(productPriceModifyLog.getExtend1() == null || productPriceModifyLog.getExtend1().length() < 255 , "扩展字段1,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend2() == null || productPriceModifyLog.getExtend2().length() < 255 , "扩展字段2,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend3() == null || productPriceModifyLog.getExtend3().length() < 255 , "扩展字段3,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend4() == null || productPriceModifyLog.getExtend4().length() < 255 , "扩展字段4,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend5() == null || productPriceModifyLog.getExtend5().length() < 255 , "扩展字段5,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend6() == null || productPriceModifyLog.getExtend6().length() < 255 , "扩展字段6,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend7() == null || productPriceModifyLog.getExtend7().length() < 255 , "扩展字段7,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getTenantCode() == null || productPriceModifyLog.getTenantCode().length() < 255 , "租户编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductCode() == null || productPriceModifyLog.getProductCode().length() < 64 , "商品编码,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductName() == null || productPriceModifyLog.getProductName().length() < 128 , "商品名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductSpecificationCode() == null || productPriceModifyLog.getProductSpecificationCode().length() < 64 , "规格编号,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductSpecificationName() == null || productPriceModifyLog.getProductSpecificationName().length() < 128 , "规格名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(productPriceModifyLog.getUnitCode() == null || productPriceModifyLog.getUnitCode().length() < 64 , "单位编号,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(productPriceModifyLog.getUnitName() == null || productPriceModifyLog.getUnitName().length() < 128 , "单位名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(productPriceModifyLog.getCustomerCode() == null || productPriceModifyLog.getCustomerCode().length() < 255 , "客户编码,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getCustomerName() == null || productPriceModifyLog.getCustomerName().length() < 128 , "客户名称,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  public ProductPriceModifyLog update(ProductPriceModifyLog productPriceModifyLog) {
    ProductPriceModifyLog current = this.updateForm(productPriceModifyLog);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  }
  @Transactional
  @Override
  public ProductPriceModifyLog updateForm(ProductPriceModifyLog productPriceModifyLog) {
    /*
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     *
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */

    this.updateValidation(productPriceModifyLog);
    // ===================基本信息
    String currentId = productPriceModifyLog.getId();
    Optional<ProductPriceModifyLog> op_currentProductPriceModifyLog = this.productPriceModifyLogRepository.findById(currentId);
    ProductPriceModifyLog currentProductPriceModifyLog = op_currentProductPriceModifyLog.orElse(null);
    currentProductPriceModifyLog = Validate.notNull(currentProductPriceModifyLog ,"未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    currentProductPriceModifyLog.setModifyAccount(SecurityUtils.getUserAccount());
    currentProductPriceModifyLog.setModifyTime(now);
    // 开始重新赋值——一般属性
    currentProductPriceModifyLog.setExtend1(productPriceModifyLog.getExtend1());
    currentProductPriceModifyLog.setExtend2(productPriceModifyLog.getExtend2());
    currentProductPriceModifyLog.setExtend3(productPriceModifyLog.getExtend3());
    currentProductPriceModifyLog.setExtend4(productPriceModifyLog.getExtend4());
    currentProductPriceModifyLog.setExtend5(productPriceModifyLog.getExtend5());
    currentProductPriceModifyLog.setExtend6(productPriceModifyLog.getExtend6());
    currentProductPriceModifyLog.setExtend7(productPriceModifyLog.getExtend7());
    currentProductPriceModifyLog.setExtend8(productPriceModifyLog.getExtend8());
    currentProductPriceModifyLog.setExtend9(productPriceModifyLog.getExtend9());
    currentProductPriceModifyLog.setExtend10(productPriceModifyLog.getExtend10());
    currentProductPriceModifyLog.setExtend11(productPriceModifyLog.getExtend11());
    currentProductPriceModifyLog.setTenantCode(productPriceModifyLog.getTenantCode());
    currentProductPriceModifyLog.setProductCode(productPriceModifyLog.getProductCode());
    currentProductPriceModifyLog.setProductName(productPriceModifyLog.getProductName());
    currentProductPriceModifyLog.setProductSpecificationCode(productPriceModifyLog.getProductSpecificationCode());
    currentProductPriceModifyLog.setProductSpecificationName(productPriceModifyLog.getProductSpecificationName());
    currentProductPriceModifyLog.setUnitCode(productPriceModifyLog.getUnitCode());
    currentProductPriceModifyLog.setUnitName(productPriceModifyLog.getUnitName());
    currentProductPriceModifyLog.setCustomerCode(productPriceModifyLog.getCustomerCode());
    currentProductPriceModifyLog.setCustomerName(productPriceModifyLog.getCustomerName());
    currentProductPriceModifyLog.setPriceType(productPriceModifyLog.getPriceType());
    currentProductPriceModifyLog.setAdjustType(productPriceModifyLog.getAdjustType());
    currentProductPriceModifyLog.setAdjustMoney(productPriceModifyLog.getAdjustMoney());
    currentProductPriceModifyLog.setOldMoney(productPriceModifyLog.getOldMoney());
    currentProductPriceModifyLog.setAfterMoney(productPriceModifyLog.getAfterMoney());

    this.productPriceModifyLogRepository.saveAndFlush(currentProductPriceModifyLog);
    return currentProductPriceModifyLog;
  }
  /**
   * 在更新一个已有的ProductPriceModifyLog模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(ProductPriceModifyLog productPriceModifyLog) {
    Validate.isTrue(!StringUtils.isBlank(productPriceModifyLog.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");

    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(productPriceModifyLog.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductCode(), "修改信息时，商品编码不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductName(), "修改信息时，商品名称不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductSpecificationCode(), "修改信息时，规格编号不能为空！");
    Validate.notBlank(productPriceModifyLog.getProductSpecificationName(), "修改信息时，规格名称不能为空！");
    Validate.notBlank(productPriceModifyLog.getUnitCode(), "修改信息时，单位编号不能为空！");
    Validate.notBlank(productPriceModifyLog.getUnitName(), "修改信息时，单位名称不能为空！");
    Validate.notNull(productPriceModifyLog.getPriceType(), "修改信息时，价格类型 1.销售价 2.进货价不能为空！");
    Validate.notNull(productPriceModifyLog.getAdjustType(), "修改信息时，调整方式： 1.按金额上调 2.按幅度上调 3.按金额下调 4.按幅度下调不能为空！");
    Validate.notNull(productPriceModifyLog.getAdjustMoney(), "修改信息时，调整金额不能为空！");
    Validate.notNull(productPriceModifyLog.getOldMoney(), "修改信息时，调整前价格不能为空！");
    Validate.notNull(productPriceModifyLog.getAfterMoney(), "修改信息时，调整后金额不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(productPriceModifyLog.getExtend1() == null || productPriceModifyLog.getExtend1().length() < 255 , "扩展字段1,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend2() == null || productPriceModifyLog.getExtend2().length() < 255 , "扩展字段2,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend3() == null || productPriceModifyLog.getExtend3().length() < 255 , "扩展字段3,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend4() == null || productPriceModifyLog.getExtend4().length() < 255 , "扩展字段4,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend5() == null || productPriceModifyLog.getExtend5().length() < 255 , "扩展字段5,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend6() == null || productPriceModifyLog.getExtend6().length() < 255 , "扩展字段6,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getExtend7() == null || productPriceModifyLog.getExtend7().length() < 255 , "扩展字段7,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getTenantCode() == null || productPriceModifyLog.getTenantCode().length() < 255 , "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductCode() == null || productPriceModifyLog.getProductCode().length() < 64 , "商品编码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductName() == null || productPriceModifyLog.getProductName().length() < 128 , "商品名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductSpecificationCode() == null || productPriceModifyLog.getProductSpecificationCode().length() < 64 , "规格编号,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(productPriceModifyLog.getProductSpecificationName() == null || productPriceModifyLog.getProductSpecificationName().length() < 128 , "规格名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(productPriceModifyLog.getUnitCode() == null || productPriceModifyLog.getUnitCode().length() < 64 , "单位编号,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(productPriceModifyLog.getUnitName() == null || productPriceModifyLog.getUnitName().length() < 128 , "单位名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(productPriceModifyLog.getCustomerCode() == null || productPriceModifyLog.getCustomerCode().length() < 255 , "客户编码,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(productPriceModifyLog.getCustomerName() == null || productPriceModifyLog.getCustomerName().length() < 128 , "客户名称,在进行修改时填入值超过了限定长度(128)，请检查!");
  }
  @Override
  public ProductPriceModifyLog findDetailsById(String id) {
    if(StringUtils.isBlank(id)) {
      return null;
    }
    return this.productPriceModifyLogRepository.findDetailsById(id);
  }
  @Override
  public ProductPriceModifyLog findById(String id) {
    if(StringUtils.isBlank(id)) {
      return null;
    }

    Optional<ProductPriceModifyLog> op = productPriceModifyLogRepository.findById(id);
    return op.orElse(null);
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    ProductPriceModifyLog current = this.findById(id);
    if(current != null) {
      this.productPriceModifyLogRepository.delete(current);
    }
  }

  @Override
  @Transactional
  public void saveBatch(List<ProductPriceModifyLog> productPriceModifyLogList) {
    Validate.notEmpty(productPriceModifyLogList,"保存信息不能为空");
    for (ProductPriceModifyLog productPriceModifyLog : productPriceModifyLogList) {
      //分为新增数据和修改数据，验证当前数据
     if(StringUtils.isNotBlank(productPriceModifyLog.getId())){
       this.updateValidation(productPriceModifyLog);
     }else{
       this.createValidation(productPriceModifyLog);
     }
    }
    productPriceModifyLogRepository.saveAll(productPriceModifyLogList);
  }

  @Override
  @Transactional
  public void save(ProductUnitSpecificationAndPrice productUnitSpecificationAndPrice, BigDecimal oldSellingPrice,BigDecimal oldReferencePurchasePrice) {
    Validate.notNull(oldSellingPrice,"原销售价不能为空");
    Validate.notNull(oldReferencePurchasePrice,"原进货价不能为空");
    Validate.notNull(productUnitSpecificationAndPrice,"修改后价格信息不能为空");
    if(productUnitSpecificationAndPrice.getSellingPrice().compareTo(oldSellingPrice)!=0){
      //修改了销售价格
      ProductPriceModifyLog productPriceModifyLog = this.convertModifyLog(productUnitSpecificationAndPrice.getProduct().getProductCode(),productUnitSpecificationAndPrice.getProduct().getProductName(),productUnitSpecificationAndPrice.getProductSpecification().getProductSpecificationCode(),productUnitSpecificationAndPrice.getProductSpecification().getProductSpecificationName(),productUnitSpecificationAndPrice.getProductUnit().getUnitCode(),productUnitSpecificationAndPrice.getProductUnit().getUnitName(),null,null, PriceType.SELLING_PRICE.getType(),oldSellingPrice,productUnitSpecificationAndPrice.getSellingPrice());
      this.productPriceModifyLogRepository.saveAndFlush(productPriceModifyLog);
    }else if(productUnitSpecificationAndPrice.getReferencePurchasePrice().compareTo(oldReferencePurchasePrice)!=0){
      //修改了订货价格
      ProductPriceModifyLog productPriceModifyLog = this.convertModifyLog(productUnitSpecificationAndPrice.getProduct().getProductCode(),productUnitSpecificationAndPrice.getProduct().getProductName(),productUnitSpecificationAndPrice.getProductSpecification().getProductSpecificationCode(),productUnitSpecificationAndPrice.getProductSpecification().getProductSpecificationName(),productUnitSpecificationAndPrice.getProductUnit().getUnitCode(),productUnitSpecificationAndPrice.getProductUnit().getUnitName(),null,null, PriceType.PURCHASE_PRICE.getType(),oldReferencePurchasePrice,productUnitSpecificationAndPrice.getReferencePurchasePrice());
      this.productPriceModifyLogRepository.saveAndFlush(productPriceModifyLog);
    }
  }

  @Override
  @Transactional
  public void save(ProductPricingUnitSpecification productPricingUnitSpecification,BigDecimal oldOrderPrice) {
    Validate.notNull(oldOrderPrice,"原价格信息不能为空");
    Validate.notNull(productPricingUnitSpecification,"修改后价格信息不能为空");
    if(productPricingUnitSpecification.getOrderPrice().compareTo(oldOrderPrice)!=0){
     //修改了价格
      ProductPriceModifyLog productPriceModifyLog = this.convertModifyLog(productPricingUnitSpecification.getProductPricing().getProduct().getProductCode(),productPricingUnitSpecification.getProductPricing().getProduct().getProductName(),productPricingUnitSpecification.getProductSpecificationCode(),productPricingUnitSpecification.getProductSpecificationName(),productPricingUnitSpecification.getUnitCode(),productPricingUnitSpecification.getUnitName(),productPricingUnitSpecification.getProductPricing().getCustomerCode(),productPricingUnitSpecification.getProductPricing().getCustomerName(), PriceType.SELLING_PRICE.getType(),oldOrderPrice,productPricingUnitSpecification.getOrderPrice());
      this.productPriceModifyLogRepository.saveAndFlush(productPriceModifyLog);
    }
  }

  private ProductPriceModifyLog convertModifyLog(String productCode, String productName, String productSpecificationCode, String productSpecificationName, String unitCode, String unitName, String customerCode, String customerName, Integer priceType, BigDecimal oldMoney, BigDecimal afterMoney) {
    ProductPriceModifyLog productPriceModifyLog = new ProductPriceModifyLog();
    productPriceModifyLog.setProductCode(productCode);
    productPriceModifyLog.setProductName(productName);
    productPriceModifyLog.setProductSpecificationCode(productSpecificationCode);
    productPriceModifyLog.setProductSpecificationName(productSpecificationName);
    productPriceModifyLog.setUnitCode(unitCode);
    productPriceModifyLog.setUnitName(unitName);
    productPriceModifyLog.setPriceType(priceType);
    productPriceModifyLog.setCustomerCode(customerCode);
    productPriceModifyLog.setCustomerName(customerName);
    productPriceModifyLog.setOldMoney(oldMoney);
    productPriceModifyLog.setAfterMoney(afterMoney);
    Date now = new Date();
    productPriceModifyLog.setCreateAccount(SecurityUtils.getUserAccount());
    productPriceModifyLog.setCreateTime(now);
    productPriceModifyLog.setModifyAccount(SecurityUtils.getUserAccount());
    productPriceModifyLog.setModifyTime(now);
    productPriceModifyLog.setTenantCode(TenantUtils.getTenantCode());
    //调整金额 和调整类型设置
    if(oldMoney.compareTo(afterMoney)>0){
      //老的金额大于新的金额
      BigDecimal adjustMoney = oldMoney.subtract(afterMoney);
      productPriceModifyLog.setAdjustMoney(adjustMoney);
      productPriceModifyLog.setAdjustType(AdjustType.MONEY_REDUCE.getType());
    }else{
      //新的金额大于老的金额
      BigDecimal adjustMoney = afterMoney.subtract(oldMoney);
      productPriceModifyLog.setAdjustMoney(adjustMoney);
      productPriceModifyLog.setAdjustType(AdjustType.MONEY_ADD.getType());
    }
    return productPriceModifyLog;
  }




}
