package com.bizunited.empower.business.product.service.notifier;

import com.bizunited.empower.business.product.entity.ProductBrand;

/**
 * 商品模块 商品品牌 事件监听
 *
 * @Author: hefan
 * @Date: 2021/4/8 16:50
 */
public interface ProductBrandEventListener {

  /**
   * 当删除 商品品牌 时，触发事件
   * @param productBrand
   * @return 警告信息
   */
  String onDelete(ProductBrand productBrand);

  /**
   * 当修改 商品与品牌 关联关系时，触发事件
   * @param productBrand
   * @return 警告信息
   */
  String onRelationshipChange(ProductBrand productBrand);
}
