package com.bizunited.empower.business.product.service.notifier;

import com.bizunited.empower.business.product.entity.ProductCategory;

/**
 * 商品模块 商品分类 事件监听
 *
 * @Author: hefan
 * @Date: 2021/4/8 16:50
 */
public interface ProductCategoryEventListener {

  /**
   * 当删除 商品分类 时，触发事件
   * @param productCategory
   * @return 警告信息
   */
  String onDelete(ProductCategory productCategory);

  /**
   * 当修改 商品与分类 关联关系时，触发事件
   * @param productCategory
   * @return 警告信息
   */
  String onRelationshipChange(ProductCategory productCategory);
}
