package com.bizunited.empower.business.product.service.notifier;


import com.bizunited.empower.business.product.entity.Product;

/**
 * 商品事件监听
 * 当商品修改或者删除时，触发的事件监听，
 * 修改商品内部元素，都是由商品触发监听
 *
 * @author lihuan
 */
public interface ProductEventListener {


  /**
   * 当商品信息删除时，触发监听事件
   * @param product
   * @return
   */
  String onDelete(Product product);

  /**
   * 当商品信息修改时，触发监听事件
   * @param product
   * @return
   */
  String onUpdate(Product product);

  /**
   * 商品上架下架状态修改 触发事件
   *
   * @param productCode 商品编码
   * @param shelfStatus 上架下架（修改上架状态 1，立即上架；2，暂不上架
   */
   void onUpdateShelfStatus(String productCode, Integer shelfStatus);
}
