package com.bizunited.empower.business.product.service.notifier;

import com.bizunited.empower.business.product.entity.ProductShowCategory;

/**
 * 商品模块 商品前端分类 事件监听
 *
 * @Author: hefan
 * @Date: 2021/4/8 16:50
 */
public interface ProductShowCategoryEventListener {

  /**
   * 当删除 商品前端分类 时，触发事件
   * @param productShowCategory
   * @return 警告信息
   */
  String onDelete(ProductShowCategory productShowCategory);

  /**
   * 当修改 商品前端分类 关联关系时，触发事件
   * @param productShowCategory
   * @return 警告信息
   */
  String onRelationshipChange(ProductShowCategory productShowCategory);
}
