package com.bizunited.empower.business.product.service.notifier;


import com.bizunited.empower.business.product.entity.ProductSpecification;

import java.util.Set;

/**
 * 商品规格监听 ，当修改商品规格或者删除商品规格时触发事件
 *
 * @author lihuan
 */
public interface ProductSpecificationEventListener {


  /**
   * 当商品修改 删除规格时 触发事件
   * 需要对应业务系统实现规格删除的对应处理
   * @param productSpecifications
   */
  void onDelete(Set<ProductSpecification> productSpecifications);

  /**
   * 当商品修改时， 修改了规格信息 触发事件
   * 需要对应业务系统实现对应处理
   * @param productSpecifications
   */
  void onUpdate(Set<ProductSpecification> productSpecifications);


}
