package com.bizunited.empower.business.product.service.notifier;

import com.bizunited.empower.business.product.entity.ProductUnitAndPrice;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Set;

/**
 * 商品单位价格信息 当修改商品单位 或者删除商品单位时，触发事件
 * @author lihuan
 */
public interface ProductUnitAndPriceEventListener {

  /**
   * 当修改商品时，如果删除了单位信息，会触发当前事件
   * 需要业务系统实现相应的处理
   * @param productUnitAndPrices
   */
  void onDelete(Set<ProductUnitAndPrice> productUnitAndPrices);

  /**
   * 当修改商品时，如果修改了单位信息，会触发当前时间
   * 需要对应业务系统实现相应处理
   * @param productUnitAndPrices left 旧数据  right 新数据
   */
  void onUpdate(Set<Pair<ProductUnitAndPrice,ProductUnitAndPrice>> productUnitAndPrices);
}
