package com.bizunited.empower.business.product.service.notifier;

import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductVo;

import java.util.List;

/**
 * 商品库存事件通知
 *
 * @author lihuan
 */
public interface ProductWarehouseEventListener {


  /**
   * 查询商品库存信息，并且丰富的商品信息中
   * @param productVos
   * @return
   */
  List<ProductVo> findProductWarehouse(List<ProductVo> productVos,String customerCode);


  /**
   * 查询单个商品库存信息 丰富到商品信息中
   * @param productVo
   * @return
   */
  ProductVo findWarehouse(ProductVo productVo,String customerCode);


  /**
   * 查询商品单规格库存信息 丰富到商品信息中
   * @param productSpecificationVo
   * @return
   */
  ProductSpecificationVo findProductSpecificationWarehouse(ProductSpecificationVo productSpecificationVo,String customerCode);


  /**
   * 查询多个规格库存信息，并且丰富到商品信息中
   * @param productSpecificationVos
   * @return
   */
  List<ProductSpecificationVo> findProductSpecificationWarehouse(List<ProductSpecificationVo> productSpecificationVos,String customerCode);

  /**
   * 根据库存编号查询多个规格库存信息，并且丰富到商品信息中
   * @param productSpecificationVos
   * @return
   */
  List<ProductSpecificationVo> findProductSpecificationWarehouseByWarehouseCode(List<ProductSpecificationVo> productSpecificationVos,String warehouseCode);


  /**
   * 通过规格编码集合查询可用库存大于0的规格编码集合
   * @param specificationCodes
   * @return
   */
  List<String> findAvailableByProductSpecificationCodes(List<String> specificationCodes,String customerCode);


  /**
   * 查询仓库编码下规格列表实际库存 大于0的 规格编码列表
   * @param specificationCodes 规格编码
   * @param warehouseCode 仓库编码
   * @return
   */
  List<String> findPracticalByProductSpecificationCodes(List<String> specificationCodes,String warehouseCode);

}
